/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.distributionfunction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterType implements Enumerator
{
    SCALAR(0, "SCALAR", "SCALAR"),
    VECTOR(1, "VECTOR", "VECTOR"),
    MATRIX(2, "MATRIX", "MATRIX"),
    SAMPLESPACE(3, "SAMPLESPACE", "SAMPLESPACE");

    public static final int SCALAR_VALUE = 0;
    public static final int VECTOR_VALUE = 1;
    public static final int MATRIX_VALUE = 2;
    public static final int SAMPLESPACE_VALUE = 3;
    private static final ParameterType[] VALUES_ARRAY;
    public static final List<ParameterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterType[]{SCALAR, VECTOR, MATRIX, SAMPLESPACE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterType get(int value) {
        switch (value) {
            case 0: {
                return SCALAR;
            }
            case 1: {
                return VECTOR;
            }
            case 2: {
                return MATRIX;
            }
            case 3: {
                return SAMPLESPACE;
            }
        }
        return null;
    }

    private ParameterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

