/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.distributionfunction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Domain implements Enumerator
{
    NATURAL(0, "NATURAL", "NATURAL"),
    INTEGER(1, "INTEGER", "INTEGER"),
    REAL(2, "REAL", "REAL"),
    CATEGORY(3, "CATEGORY", "CATEGORY");

    public static final int NATURAL_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int REAL_VALUE = 2;
    public static final int CATEGORY_VALUE = 3;
    private static final Domain[] VALUES_ARRAY;
    public static final List<Domain> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Domain[]{NATURAL, INTEGER, REAL, CATEGORY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Domain get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Domain result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Domain getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Domain result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Domain get(int value) {
        switch (value) {
            case 0: {
                return NATURAL;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return REAL;
            }
            case 3: {
                return CATEGORY;
            }
        }
        return null;
    }

    private Domain(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

