/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.parser;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Matrix;
import tools.mdsd.probdist.api.entity.Vector;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.distributionfunction.ParameterType;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;

public class DefaultParameterParser
implements ParameterParser {
    public static final String SAMPLE_DELIMITER = ";";
    public static final String PAIR_DELIMITER = ",";
    public static final String FLOATING_POINT_PATTERN = "[-+]?[0-9]+\\.?[0-9]*";
    public static final String VECTOR_PATTERN = String.format("\\[(%1s)(,%2s)+\\]", "[-+]?[0-9]+\\.?[0-9]*", "[-+]?[0-9]+\\.?[0-9]*");
    public static final String MATRIX_PATTERN = String.format("\\[(%1s)(,%2s)+\\]", VECTOR_PATTERN, VECTOR_PATTERN);
    public static final String SAMPLESPACE_PATTERN = String.format("\\{(.)+,%1s\\}(%2s\\{(.)+,%3s\\})*", "[-+]?[0-9]+\\.?[0-9]*", ";", "[-+]?[0-9]+\\.?[0-9]*");

    @Override
    public Double parseScalar(SimpleParameter param) {
        if (param.getType() != ParameterType.SCALAR) {
            throw new IllegalArgumentException("The paramter type is not a scalar.");
        }
        return Double.parseDouble(param.getValue());
    }

    @Override
    public Vector parseVector(SimpleParameter param) {
        if (param.getType() != ParameterType.VECTOR) {
            throw new IllegalArgumentException("The paramter type is not a vector.");
        }
        this.checkSchemaConformance(param.getValue(), VECTOR_PATTERN);
        return Vector.of(this.extractElements(param.getValue()));
    }

    @Override
    public Matrix parseMatrix(SimpleParameter param) {
        if (param.getType() != ParameterType.MATRIX) {
            throw new IllegalArgumentException("The paramter type is not a matrix.");
        }
        this.checkSchemaConformance(param.getValue(), MATRIX_PATTERN);
        return Matrix.of(this.extractVectors(param.getValue()));
    }

    @Override
    public Set<ParameterParser.Sample> parseSampleSpace(SimpleParameter param) {
        if (param.getType() != ParameterType.SAMPLESPACE) {
            throw new IllegalArgumentException("The paramter type is no sample space.");
        }
        this.checkSchemaConformance(param.getValue(), SAMPLESPACE_PATTERN);
        return this.extractSamples(param.getValue());
    }

    private void checkSchemaConformance(String value, String regex) {
        if (!value.matches(regex)) {
            throw new ProbabilityDistributionException(String.format("The paramter value %s does not fullfill the specification schema.", value));
        }
    }

    private List<Double> extractElements(String value) {
        ArrayList<Double> elements = new ArrayList<Double>();
        Matcher matcher = Pattern.compile(FLOATING_POINT_PATTERN).matcher(value);
        while (matcher.find()) {
            Double element = Double.parseDouble(matcher.group());
            elements.add(element);
        }
        return elements;
    }

    private List<Vector> extractVectors(String value) {
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        Matcher matcher = Pattern.compile(VECTOR_PATTERN).matcher(value);
        while (matcher.find()) {
            List<Double> elements = this.extractElements(value);
            vectors.add(Vector.of(elements));
        }
        return vectors;
    }

    private Set<ParameterParser.Sample> extractSamples(String value) {
        return Stream.of(value.split(SAMPLE_DELIMITER)).map(this.toSample()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Function<String, ParameterParser.Sample> toSample() {
        return s -> {
            String[] pair = this.removeAllSpaces(this.removeAllBraces((String)s)).split(PAIR_DELIMITER);
            return new ParameterParser.Sample(CategoricalValue.create(pair[0]), Double.parseDouble(pair[1]));
        };
    }

    private String removeAllBraces(String s) {
        return s.replaceAll("(\\{|\\})", "");
    }

    private String removeAllSpaces(String s) {
        return s.replaceAll("\\s", "");
    }
}

