/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tools.mdsd.probdist.api.builder.CategoricalProbabilityDistributionBuilder;
import tools.mdsd.probdist.api.builder.ProbabilityDistributionBuilder;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.factory.CategoricalProbabilityCalculator;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionRegistry;
import tools.mdsd.probdist.api.factory.ProbabilityCalculator;
import tools.mdsd.probdist.api.factory.ProbabilityDistributionSupplier;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;

public class ProbabilityDistributionFactory
implements IProbabilityDistributionRegistry<CategoricalValue>,
IProbabilityDistributionFactory<CategoricalValue> {
    private final Map<String, ProbabilityDistributionSupplier<CategoricalValue>> registry = new HashMap<String, ProbabilityDistributionSupplier<CategoricalValue>>();
    private final Optional<ISeedProvider> seedProvider;

    public ProbabilityDistributionFactory(Optional<ISeedProvider> seedProvider) {
        this.seedProvider = seedProvider;
    }

    @Override
    public Optional<ProbabilityDistributionFunction<CategoricalValue>> getInstanceOf(ProbabilityDistribution distribution) {
        if (this.registry.isEmpty()) {
            throw new RuntimeException("registry is empty");
        }
        ProbabilityDistributionSupplier<CategoricalValue> supplier = this.queryRegister(distribution);
        if (supplier == null) {
            throw new RuntimeException("probability distribution supplier not found");
        }
        ProbabilityDistributionFunction<CategoricalValue> pdf = supplier.get(distribution);
        if (pdf != null) {
            pdf.init(this.seedProvider);
        }
        return Optional.of(pdf);
    }

    @Override
    public void register(ProbabilityDistributionSupplier<CategoricalValue> supplier) {
        if (this.isAlreadyRegistered(supplier)) {
            throw new RuntimeException(String.format("supplier %s already registered", supplier.getClass().getName()));
        }
        this.registry.put(supplier.getImplementedSkeleton().getId(), supplier);
    }

    @Override
    public void unregister(ProbabilityDistributionSupplier<CategoricalValue> supplier) {
        this.registry.remove(supplier.getImplementedSkeleton().getId());
    }

    private ProbabilityDistributionSupplier<CategoricalValue> queryRegister(ProbabilityDistribution distribution) {
        return this.registry.get(distribution.getInstantiated().getId());
    }

    private boolean isAlreadyRegistered(ProbabilityDistributionSupplier<CategoricalValue> supplier) {
        return this.registry.containsKey(supplier.getImplementedSkeleton().getId());
    }

    @Override
    public ProbabilityCalculator<CategoricalValue> getProbabilityCalculator() {
        return new CategoricalProbabilityCalculator();
    }

    @Override
    public ProbabilityDistributionBuilder<CategoricalValue> getProbabilityDistributionBuilder() {
        return CategoricalProbabilityDistributionBuilder.create(this);
    }
}

