/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;

public class Vector {
    private static final BiFunction<Double, Double, Double> ADDITION = (e1, e2) -> e1 + e2;
    private static final BiFunction<Double, Double, Double> SUBTRACTION = (e1, e2) -> e1 - e2;
    private static final BiFunction<Double, Double, Double> MULTIPLICATION = (e1, e2) -> e1 * e2;
    private final java.util.Vector<Double> vector = new java.util.Vector();

    private Vector(List<Double> elements) {
        this.vector.addAll(elements);
    }

    public static Vector of(Double ... elements) {
        return Vector.of(Arrays.asList(elements));
    }

    public static Vector of(List<Double> elements) {
        return new Vector(elements);
    }

    public Vector add(Vector other) {
        this.checkValidity(other);
        return VectorOperation.applyTo(this, other).elementWise(ADDITION);
    }

    public Vector sub(Vector other) {
        this.checkValidity(other);
        return VectorOperation.applyTo(this, other).elementWise(SUBTRACTION);
    }

    public Double mult(Vector other) {
        this.checkValidity(other);
        Stream result = VectorOperation.applyTo(this, other).elementWise(MULTIPLICATION).getElements().stream();
        return (Double)result.reduce(Double::sum).get();
    }

    public Double getElementAt(int index) {
        return this.vector.elementAt(index);
    }

    public List<Double> getElements() {
        return Collections.list(this.vector.elements());
    }

    public int getDimension() {
        return this.vector.capacity();
    }

    private void checkValidity(Vector other) {
        if (this.getDimension() != other.getDimension()) {
            throw new ProbabilityDistributionException("The vector dimensions are not equal.", new IllegalArgumentException());
        }
    }

    private static class VectorOperation {
        public static final VectorOperation helperInstance = new VectorOperation();
        private Vector v1;
        private Vector v2;

        private VectorOperation() {
        }

        public static VectorOperation applyTo(Vector v1, Vector v2) {
            VectorOperation.helperInstance.v1 = v1;
            VectorOperation.helperInstance.v2 = v2;
            return helperInstance;
        }

        public Vector elementWise(BiFunction<Double, Double, Double> operation) {
            ArrayList<Double> result = new ArrayList<Double>();
            int i = 0;
            while (i < this.v1.getDimension()) {
                result.add(operation.apply(this.v1.getElementAt(i), this.v2.getElementAt(i)));
                ++i;
            }
            return Vector.of(result);
        }
    }
}

