/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tools.mdsd.probdist.api.entity.CPDRepresentation;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.distributionfunction.RandomVariable;

public class TabularCPDRepresentation
implements CPDRepresentation<CategoricalValue> {
    private final Set<CPDTableEntry> conditionalTable = new LinkedHashSet<CPDTableEntry>();

    private TabularCPDRepresentation(Set<CPDTableEntry> conditionalTable) {
        this.conditionalTable.addAll(conditionalTable);
    }

    @Override
    public Optional<ProbabilityDistributionFunction<CategoricalValue>> getPDFGiven(List<Conditionable.Conditional<CategoricalValue>> conditionals) {
        Optional<CPDTableEntry> result = this.getEntries().filter(this.entryMatching(conditionals)).findFirst();
        if (result.isPresent()) {
            CPDTableEntry cpdTableEntry = result.get();
            return Optional.of(cpdTableEntry.pdf);
        }
        return Optional.empty();
    }

    public TabularCPDBuilder builder() {
        return new TabularCPDBuilder();
    }

    private Stream<CPDTableEntry> getEntries() {
        return this.conditionalTable.stream();
    }

    private Predicate<CPDTableEntry> entryMatching(List<Conditionable.Conditional<CategoricalValue>> conditionals) {
        return entry -> entry.matches(conditionals);
    }

    private static class CPDTableEntry {
        public List<Conditionable.Conditional<CategoricalValue>> orderedConditionals = new ArrayList<Conditionable.Conditional<CategoricalValue>>();
        public ProbabilityDistributionFunction<CategoricalValue> pdf;

        public CPDTableEntry(List<Conditionable.Conditional<CategoricalValue>> orderedConditionals, ProbabilityDistributionFunction<CategoricalValue> pdf) {
            this.orderedConditionals = orderedConditionals;
            this.pdf = pdf;
        }

        public boolean matches(List<Conditionable.Conditional<CategoricalValue>> orderedConditionalsToCheck) {
            if (orderedConditionalsToCheck.size() != this.orderedConditionals.size()) {
                return false;
            }
            int i = 0;
            while (i < orderedConditionalsToCheck.size()) {
                if (!orderedConditionalsToCheck.get(i).equals(this.orderedConditionals.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class TabularCPDBuilder
    extends CPDRepresentation.CPDRepresentationBuilder<CategoricalValue> {
        private final List<RandomVariable> tableHeader = new ArrayList<RandomVariable>();
        private final List<TableEntry> tableEntries = new ArrayList<TableEntry>();

        public TabularCPDBuilder addConditionalSignature(RandomVariable ... randomVariables) {
            if (randomVariables.length == 0) {
                throw new ProbabilityDistributionException("The conditional signature has to include at least one random variable.");
            }
            this.tableHeader.addAll(Arrays.asList(randomVariables));
            return this;
        }

        public TabularCPDBuilder addValueEntry(ProbabilityDistributionFunction<CategoricalValue> pdf, CategoricalValue values) {
            List<CategoricalValue> orderedValues = Arrays.asList(values);
            if (this.matchesTableHeader(orderedValues)) {
                this.tableEntries.add(new TableEntry(orderedValues, pdf));
            }
            throw new ProbabilityDistributionException("The values do not match the signature of the table header.");
        }

        private boolean matchesTableHeader(List<CategoricalValue> orderedValues) {
            if (this.tableHeader.isEmpty() || this.tableHeader.size() != orderedValues.size()) {
                return false;
            }
            int i = 0;
            while (i < orderedValues.size()) {
                if (orderedValues.get(i).getDomain() != this.tableHeader.get(i).getValueSpace()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public CPDRepresentation<CategoricalValue> build() {
            return new TabularCPDRepresentation(this.buildConditionalTable());
        }

        private Set<CPDTableEntry> buildConditionalTable() {
            if (this.tableEntries.isEmpty()) {
                throw new ProbabilityDistributionException("There are no table entries specified.");
            }
            LinkedHashSet<CPDTableEntry> conditionalTable = new LinkedHashSet<CPDTableEntry>();
            for (TableEntry each : this.tableEntries) {
                conditionalTable.add(this.buildConditionalEntry(each));
            }
            return conditionalTable;
        }

        private CPDTableEntry buildConditionalEntry(TableEntry tableEntries) {
            ArrayList<Conditionable.Conditional<CategoricalValue>> conditionals = new ArrayList<Conditionable.Conditional<CategoricalValue>>();
            int i = 0;
            while (i < tableEntries.values.size()) {
                conditionals.add(new Conditionable.Conditional<CategoricalValue>(this.tableHeader.get(i), tableEntries.values.get(i)));
                ++i;
            }
            return new CPDTableEntry(conditionals, tableEntries.pdf);
        }

        private static class TableEntry {
            public List<CategoricalValue> values;
            public ProbabilityDistributionFunction<CategoricalValue> pdf;

            public TableEntry(List<CategoricalValue> values, ProbabilityDistributionFunction<CategoricalValue> pdf) {
                this.values = values;
                this.pdf = pdf;
            }
        }
    }
}

