/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.entity;

import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.distributionfunction.Domain;

public class NumericalValue
extends Value<Number> {
    private NumericalValue(Number value, Domain domain) {
        super(value, domain);
    }

    public static NumericalValue create(Number value, Domain domain) {
        return new NumericalValue(value, domain);
    }

    public static NumericalValue create(Double value) {
        return new NumericalValue(value, Domain.REAL);
    }

    public Integer asNatural() {
        if (this.isNoNatural()) {
            throw new ProbabilityDistributionException("The value is not a natural number.");
        }
        return ((Number)this.value).intValue();
    }

    public Integer asInteger() {
        if (this.isRealNumber()) {
            throw new ProbabilityDistributionException("The value is not a integer number.");
        }
        return ((Number)this.value).intValue();
    }

    public Double asReal() {
        return ((Number)this.value).doubleValue();
    }

    private boolean isNoNatural() {
        return ((Number)this.value).intValue() < 0 && this.domain == Domain.NATURAL;
    }

    private boolean isRealNumber() {
        return this.domain == Domain.REAL;
    }

    public boolean equals(Object other) {
        if (other instanceof NumericalValue) {
            NumericalValue otherVal = (NumericalValue)other;
            return this.domain == otherVal.getDomain() && ((Number)this.value).equals(otherVal.value);
        }
        return false;
    }

    public String toString() {
        return ((Number)this.value).toString();
    }
}

