/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import tools.mdsd.probdist.api.entity.CPDEvaluator;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.ConditionableProbabilityDistribution;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.entity.TabularCPDEvaluator;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.TabularCPD;

public class ConditionalProbabilityDistribution
extends ProbabilityDistributionFunction<CategoricalValue>
implements ConditionableProbabilityDistribution<CategoricalValue> {
    private final CPDEvaluator cpdEvaluator;
    private final List<Conditionable.Conditional<CategoricalValue>> conditionals;

    public ConditionalProbabilityDistribution(ProbabilityDistribution distribution, TabularCPD tabularCPD, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        super(distribution.getInstantiated());
        this.cpdEvaluator = new TabularCPDEvaluator(tabularCPD, distribution, probabilityDistributionFactory);
        this.conditionals = new ArrayList<Conditionable.Conditional<CategoricalValue>>();
    }

    @Override
    public Double probability(CategoricalValue value) {
        return this.cpdEvaluator.evaluate(value, this.conditionals);
    }

    @Override
    public void init(Optional<ISeedProvider> seedProvider) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.cpdEvaluator.init(seedProvider);
    }

    @Override
    public CategoricalValue sample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        ProbabilityDistributionFunction<CategoricalValue> cpdGiven = this.cpdEvaluator.getCPDGiven(this.conditionals);
        return (CategoricalValue)cpdGiven.sample();
    }

    public ConditionalProbabilityDistribution given(List<Conditionable.Conditional<CategoricalValue>> conditionals) {
        this.conditionals.clear();
        this.conditionals.addAll(conditionals);
        return this;
    }
}

