/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.builder;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.probdist.api.builder.ProbabilityDistributionBuilder;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.ConditionalProbabilityDistribution;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.TabularCPD;

public class CategoricalProbabilityDistributionBuilder
implements ProbabilityDistributionBuilder<CategoricalValue> {
    private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
    private ProbabilityDistribution distribution = null;
    private boolean asCPD = false;

    private CategoricalProbabilityDistributionBuilder(IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        this.probabilityDistributionFactory = probabilityDistributionFactory;
    }

    public static CategoricalProbabilityDistributionBuilder create(IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        return new CategoricalProbabilityDistributionBuilder(probabilityDistributionFactory);
    }

    public CategoricalProbabilityDistributionBuilder withStructure(ProbabilityDistribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public CategoricalProbabilityDistributionBuilder asConditionalProbabilityDistribution() {
        this.asCPD = true;
        return this;
    }

    @Override
    public ProbabilityDistributionFunction<CategoricalValue> build() {
        Objects.requireNonNull(this.distribution, "There need to be a probability distribution function.");
        if (this.asCPD) {
            return this.createCPD();
        }
        ProbabilityDistributionFunction<CategoricalValue> pdf = this.queryRealisation(this.probabilityDistributionFactory);
        return pdf;
    }

    private ProbabilityDistributionFunction<CategoricalValue> queryRealisation(IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        return probabilityDistributionFactory.getInstanceOf(this.distribution).orElseThrow(() -> new ProbabilityDistributionException(String.format("There is no realisation for the PDF: %s", this.distribution.getInstantiated().getEntityName())));
    }

    private ProbabilityDistributionFunction<CategoricalValue> createCPD() {
        EList params = this.distribution.getParams();
        if (this.isTabularCPD((List<Parameter>)params)) {
            Parameter firstParameter = (Parameter)params.get(0);
            TabularCPD representation = (TabularCPD)firstParameter.getRepresentation();
            return new ConditionalProbabilityDistribution(this.distribution, representation, this.probabilityDistributionFactory);
        }
        throw new ProbabilityDistributionException(String.format("The probability distribution of type %s cannot be used as a CPD.", this.distribution.getInstantiated().getEntityName()));
    }

    private boolean isTabularCPD(List<Parameter> params) {
        if (params.size() != 1) {
            return false;
        }
        return TabularCPD.class.isInstance(params.get(0).getRepresentation());
    }
}

