/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.apache.supplier;

import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import tools.mdsd.probdist.api.apache.entity.impl.MultivariateNormalDistribution;
import tools.mdsd.probdist.api.apache.entity.impl.UnivariateNormalDistribution;
import tools.mdsd.probdist.api.apache.util.DistributionTypeModelUtil;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.apache.util.ValueUtil;
import tools.mdsd.probdist.api.entity.Matrix;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.entity.Vector;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.api.factory.ProbabilityDistributionSupplier;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ParameterType;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributiontype.ParameterSignature;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;

public class NormalDistributionSupplier
implements ProbabilityDistributionSupplier {
    private static final String ND_SKELETON_DISTRIBUTION_NAME = "NormalDistribution";
    private static final String MEAN_PARAMETER_SIGNATURE_NAME = "Mean";
    private static final String VARIANCE_PARAMETER_SIGNATURE_NAME = "Variance";
    private final ProbabilityDistributionSkeleton distSkeleton;
    private final ParameterSignature mean;
    private final ParameterSignature variance;
    private final ParameterParser parameterParser;

    public NormalDistributionSupplier(ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup) {
        this.distSkeleton = probDistRepoLookup.findSkeleton(ND_SKELETON_DISTRIBUTION_NAME).orElseThrow(() -> new ProbabilityDistributionException(String.format("Skeleton %s is not included in the basic distribtuion model.", ND_SKELETON_DISTRIBUTION_NAME)));
        this.mean = probDistRepoLookup.findParameterSignatureWith(MEAN_PARAMETER_SIGNATURE_NAME).orElseThrow(() -> new ProbabilityDistributionException(String.format("There is no paramter signature with name %s.", MEAN_PARAMETER_SIGNATURE_NAME)));
        this.variance = probDistRepoLookup.findParameterSignatureWith(VARIANCE_PARAMETER_SIGNATURE_NAME).orElseThrow(() -> new ProbabilityDistributionException(String.format("There is no paramter signature with name %s.", VARIANCE_PARAMETER_SIGNATURE_NAME)));
        this.parameterParser = parameterParser;
    }

    public ProbabilityDistributionFunction<?> get(ProbabilityDistribution distribution) {
        SimpleParameter varInstant;
        SimpleParameter meanInstant = this.retrieveMeanParameter((List<Parameter>)distribution.getParams());
        if (this.isUnivariate(meanInstant, varInstant = this.retrieveVarianceParameter((List<Parameter>)distribution.getParams()))) {
            return this.createUnivariateND(meanInstant, varInstant);
        }
        if (this.isMultivariate(meanInstant, varInstant)) {
            return this.createMultivariateND(meanInstant, varInstant);
        }
        throw new ProbabilityDistributionException(String.format("Parameter types are incorrect for distribution %s", ND_SKELETON_DISTRIBUTION_NAME));
    }

    public ProbabilityDistributionSkeleton getImplementedSkeleton() {
        return this.distSkeleton;
    }

    private SimpleParameter retrieveMeanParameter(List<Parameter> params) {
        return this.retrieveParameter(this.mean, params);
    }

    private SimpleParameter retrieveVarianceParameter(List<Parameter> params) {
        return this.retrieveParameter(this.variance, params);
    }

    private SimpleParameter retrieveParameter(ParameterSignature paramSignature, List<Parameter> params) {
        List<Parameter> results = DistributionTypeModelUtil.filterParametersWithSimpleRepresentation(paramSignature, params);
        if (results.isEmpty()) {
            throw new ProbabilityDistributionException(String.format("There is no paramter instantiation for signature %s", paramSignature.getEntityName()));
        }
        return (SimpleParameter)results.get(0).getRepresentation();
    }

    private boolean isUnivariate(SimpleParameter meanInstant, SimpleParameter varInstant) {
        return meanInstant.getType() == ParameterType.SCALAR && varInstant.getType() == ParameterType.SCALAR;
    }

    private boolean isMultivariate(SimpleParameter meanInstant, SimpleParameter varInstant) {
        return meanInstant.getType() == ParameterType.VECTOR && varInstant.getType() == ParameterType.MATRIX;
    }

    private ProbabilityDistributionFunction<?> createUnivariateND(SimpleParameter meanInstant, SimpleParameter varInstant) {
        double mean = this.parameterParser.parseScalar(meanInstant);
        double variance = this.parameterParser.parseScalar(varInstant);
        return new UnivariateNormalDistribution(this.distSkeleton, new NormalDistribution(mean, Math.sqrt(variance)));
    }

    private ProbabilityDistributionFunction<?> createMultivariateND(SimpleParameter meanInstant, SimpleParameter varInstant) {
        Vector meanVec = this.parameterParser.parseVector(meanInstant);
        Matrix covMatrix = this.parameterParser.parseMatrix(varInstant);
        return new MultivariateNormalDistribution(this.distSkeleton, new org.apache.commons.math3.distribution.MultivariateNormalDistribution(ValueUtil.asDoubleArray(meanVec), ValueUtil.asDouble2DArray(covMatrix)));
    }
}

