/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.apache.supplier;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;
import tools.mdsd.probdist.api.apache.entity.impl.MultinomialDistribution;
import tools.mdsd.probdist.api.apache.util.DistributionTypeModelUtil;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.ProbabilityDistributionFunction;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.api.factory.ProbabilityDistributionSupplier;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributiontype.ParameterSignature;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;

public class MultinomialDistributionSupplier
implements ProbabilityDistributionSupplier<CategoricalValue> {
    private static final String MD_SKELETON_DISTRIBUTION_NAME = "MultinomialDistribution";
    private static final String EP_PARAMETER_SIGNATURE_NAME = "EventProbability";
    private final ProbabilityDistributionSkeleton distSkeleton;
    private final ParameterSignature eventProbability;
    private final ParameterParser parameterParser;

    public MultinomialDistributionSupplier(ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup) {
        this.distSkeleton = probDistRepoLookup.findSkeleton(MD_SKELETON_DISTRIBUTION_NAME).orElseThrow(() -> new ProbabilityDistributionException(String.format("Skeleton %s is not included in the basic distribtuion model.", MD_SKELETON_DISTRIBUTION_NAME)));
        this.eventProbability = probDistRepoLookup.findParameterSignatureWith(EP_PARAMETER_SIGNATURE_NAME).orElseThrow(() -> new ProbabilityDistributionException(String.format("There is no parameter signature with name %s.", EP_PARAMETER_SIGNATURE_NAME)));
        this.parameterParser = parameterParser;
    }

    public ProbabilityDistributionFunction<CategoricalValue> get(ProbabilityDistribution distribution) {
        SimpleParameter instantiated = this.retrieveParameter((List<Parameter>)distribution.getParams());
        List<Pair<CategoricalValue, Double>> sampleSpace = this.createSampleSpace(instantiated);
        EnumeratedDistribution enumDistribution = new EnumeratedDistribution(sampleSpace);
        return new MultinomialDistribution(this.distSkeleton, (EnumeratedDistribution<CategoricalValue>)enumDistribution);
    }

    private SimpleParameter retrieveParameter(List<Parameter> params) {
        List<Parameter> results = DistributionTypeModelUtil.filterParametersWithSimpleRepresentation(this.eventProbability, params);
        if (results.isEmpty()) {
            throw new ProbabilityDistributionException(String.format("There is no parameter instantiation for signature %s", this.eventProbability.getEntityName()));
        }
        return (SimpleParameter)results.get(0).getRepresentation();
    }

    public ProbabilityDistributionSkeleton getImplementedSkeleton() {
        return this.distSkeleton;
    }

    private List<Pair<CategoricalValue, Double>> createSampleSpace(SimpleParameter instantiated) {
        return this.parameterParser.parseSampleSpace(instantiated).stream().map(this::toPair).collect(Collectors.toList());
    }

    public Pair<CategoricalValue, Double> toPair(ParameterParser.Sample s) {
        return Pair.create((Object)s.value, (Object)s.probability);
    }
}

