/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.apache.entity.impl;

import java.util.Optional;
import org.apache.commons.math3.distribution.NormalDistribution;
import tools.mdsd.probdist.api.entity.NumericalValue;
import tools.mdsd.probdist.api.entity.UnivariateProbabilityDensityFunction;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;

public class UnivariateNormalDistribution
extends UnivariateProbabilityDensityFunction {
    private final NormalDistribution normalDist;

    public UnivariateNormalDistribution(ProbabilityDistributionSkeleton distSkeleton, NormalDistribution normalDist) {
        super(distSkeleton);
        this.normalDist = normalDist;
    }

    public Double probability(NumericalValue value) {
        return this.normalDist.density(value.asReal().doubleValue());
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        if (this.initialized) {
            throw new RuntimeException("initialized");
        }
        this.initialized = true;
        seedProvider.ifPresent(sp -> this.normalDist.reseedRandomGenerator(sp.getLong()));
    }

    public NumericalValue sample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return NumericalValue.create((Double)this.normalDist.sample());
    }
}

