/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.apache.entity.impl;

import java.util.List;
import java.util.Optional;
import tools.mdsd.probdist.api.apache.util.ValueUtil;
import tools.mdsd.probdist.api.entity.MultivariateProbabilityDensityFunction;
import tools.mdsd.probdist.api.entity.NumericalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;

public class MultivariateNormalDistribution
extends MultivariateProbabilityDensityFunction {
    private final org.apache.commons.math3.distribution.MultivariateNormalDistribution normalDistribution;

    public MultivariateNormalDistribution(ProbabilityDistributionSkeleton distSkeleton, org.apache.commons.math3.distribution.MultivariateNormalDistribution normalDistribution) {
        super(distSkeleton);
        this.normalDistribution = normalDistribution;
    }

    public Double probability(List<NumericalValue> value) {
        return this.normalDistribution.density(ValueUtil.asDoubleArray(value));
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        if (this.initialized) {
            throw new RuntimeException("initialized");
        }
        this.initialized = true;
        seedProvider.ifPresent(sp -> this.normalDistribution.reseedRandomGenerator(sp.getLong()));
    }

    public List<NumericalValue> sample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return ValueUtil.toValueList(this.normalDistribution.sample(), v -> NumericalValue.create((Double)v));
    }
}

