/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.probdist.api.apache.entity.impl;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.UnivariateProbabilitiyMassFunction;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.exception.ProbabilityDistributionException;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;

public class MultinomialDistribution
extends UnivariateProbabilitiyMassFunction {
    private final EnumeratedDistribution<CategoricalValue> multDistribution;

    public MultinomialDistribution(ProbabilityDistributionSkeleton distSkeleton, EnumeratedDistribution<CategoricalValue> multDistribution) {
        super(distSkeleton);
        this.multDistribution = multDistribution;
    }

    public Double probability(CategoricalValue value) {
        return (Double)this.findPairWith((Value<?>)value).getValue();
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        seedProvider.ifPresent(sp -> this.multDistribution.reseedRandomGenerator(sp.getLong()));
    }

    public CategoricalValue sample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return (CategoricalValue)this.multDistribution.sample();
    }

    private Pair<CategoricalValue, Double> findPairWith(Value<?> value) {
        return this.getSampleSpace().filter(s -> this.withSameValue((CategoricalValue)s.getKey(), value)).findFirst().orElseThrow(() -> new ProbabilityDistributionException(String.format("There is no sample with value: %s", value.get())));
    }

    private boolean withSameValue(CategoricalValue cValue, Value<?> value) {
        if (!CategoricalValue.class.isInstance(value)) {
            return false;
        }
        return ((String)((CategoricalValue)CategoricalValue.class.cast(value)).get()).equals(cValue.get());
    }

    private Stream<Pair<CategoricalValue, Double>> getSampleSpace() {
        return this.multDistribution.getPmf().stream();
    }
}

