/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.standalone;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.EmptyModel;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.parser.jdt.JaMoPPJDTParser;
import tools.mdsd.jamopp.resource.JavaResource2Factory;

public class JaMoPPStandalone {
    private static final String INPUT = "";
    private static final boolean ENABLE_OUTPUT_OF_LIBRARY_FILES = false;

    public static void main(String[] agrs) throws Exception {
        EmptyModel root = ContainersFactory.eINSTANCE.createEmptyModel();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("java", new JavaResource2Factory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        JaMoPPJDTParser parser = new JaMoPPJDTParser();
        ResourceSet rs = parser.parseUri(URI.createURI((String)INPUT));
        EcoreUtil.resolveAll((ResourceSet)rs);
        String outputFileName = INPUT;
        for (Resource javaResource : new ArrayList(rs.getResources())) {
            if (javaResource.getContents().isEmpty()) {
                System.out.println("WARNING: Emtpy Resource: " + String.valueOf(javaResource.getURI()));
                continue;
            }
            if (!javaResource.getURI().scheme().equals("file")) continue;
            File outputFile = new File("." + File.separator + "./standalone_output" + File.separator + JaMoPPStandalone.checkScheme(javaResource));
            outputFile.getParentFile().mkdirs();
            URI xmiFileURI = URI.createFileURI((String)outputFile.getAbsolutePath()).appendFileExtension("xmi");
            Resource xmiResource = rs.createResource(xmiFileURI);
            xmiResource.getContents().addAll((Collection)javaResource.getContents());
        }
        for (Resource xmiResource : rs.getResources()) {
            if (!(xmiResource instanceof XMIResource)) continue;
            try {
                xmiResource.save(rs.getLoadOptions());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String checkScheme(Resource javaResource) {
        int emptyFileName = 0;
        Object outputFileName = INPUT;
        EmptyModel root = ContainersFactory.eINSTANCE.createEmptyModel();
        root = (JavaRoot)javaResource.getContents().get(0);
        if (root instanceof CompilationUnit) {
            outputFileName = root.getNamespacesAsString().replace(".", File.separator) + File.separator;
            CompilationUnit cu = (CompilationUnit)root;
            outputFileName = cu.getClassifiers().size() > 0 ? (String)outputFileName + ((ConcreteClassifier)cu.getClassifiers().get(0)).getName() : (String)outputFileName + emptyFileName++;
        } else if (root instanceof Package) {
            outputFileName = root.getNamespacesAsString().replace(".", File.separator) + File.separator + "package-info";
            if (((String)outputFileName).startsWith(File.separator)) {
                outputFileName = ((String)outputFileName).substring(1);
            }
        } else if (root instanceof Module) {
            outputFileName = root.getNamespacesAsString().replace(".", File.separator) + File.separator + "module-info";
        }
        return outputFileName;
    }
}

