/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Origin;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.parser.bcel.ClassFileModelLoader;
import tools.mdsd.jamopp.parser.jdt.singlefile.JaMoPPJDTSingleFileParser;
import tools.mdsd.jamopp.printer.JaMoPPPrinter;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragment;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragmentCollector;
import tools.mdsd.jamopp.resolution.resolver.CentralReferenceResolver;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaElementMapping;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaReferenceMapping;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaReferenceResolveResult;

public class JavaResource2
extends XMIResourceImpl {
    public static final String JAVAXMI_FILE_EXTENSION = "javaxmi";
    private Map<String, IJavaContextDependentURIFragment> internalURIFragmentMap = IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.getContextDependentURIFragmentMap();

    public JavaResource2() {
    }

    public JavaResource2(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream input, Map<?, ?> options) throws IOException {
        if (this.getURI().fileExtension().equals(JAVAXMI_FILE_EXTENSION)) {
            super.doLoad(input, options);
            return;
        }
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.setBaseURI(this.getURI());
        CompilationUnit result = null;
        URI physicalURI = this.getURI().isFile() ? this.getURI() : (URI)JavaClasspath.get((Resource)this).getURIMap().get(this.getURI());
        if (physicalURI == null) {
            throw new IllegalStateException("There has to be a physical URI.");
        }
        String extension = physicalURI.fileExtension();
        if (extension.equals("class")) {
            try {
                result = new ClassFileModelLoader().parse(input, "");
                JavaClasspath.get((Resource)this).registerJavaRoot((JavaRoot)result, physicalURI);
                this.getContents().add((Object)result);
            }
            catch (IOException iOException) {}
        } else {
            JaMoPPJDTSingleFileParser api = new JaMoPPJDTSingleFileParser();
            api.setResourceSet(this.getResourceSet());
            result = api.parse(this.getURI().toString(), input);
            JavaRoot root = (JavaRoot)result;
            root.setOrigin(physicalURI.isFile() ? Origin.FILE : Origin.ARCHIVE);
            JavaClasspath.get((Resource)this).registerJavaRoot(root, physicalURI);
            this.getContents().add((Object)result);
            api.setResourceSet(this.getResourceSet());
            api.resolveBindings();
        }
    }

    public void doSave(OutputStream output, Map<?, ?> options) throws IOException {
        if (this.getURI().fileExtension().equals(JAVAXMI_FILE_EXTENSION)) {
            super.doSave(output, options);
        } else {
            this.getContents().forEach(object -> {
                if (object instanceof JavaRoot) {
                    JaMoPPPrinter.print((JavaRoot)((JavaRoot)object), (OutputStream)output);
                }
            });
        }
    }

    public EObject getEObject(String id) {
        if (this.internalURIFragmentMap.containsKey(id)) {
            IJavaContextDependentURIFragment uriFragment = this.internalURIFragmentMap.get(id);
            IJavaReferenceResolveResult result = null;
            try {
                result = CentralReferenceResolver.GLOBAL_INSTANCE.resolve(uriFragment);
            }
            catch (Exception e) {
                String message = "An expection occured while resolving the proxy for: " + id + ". (" + e.toString() + ")";
                e.printStackTrace();
            }
            if (result == null) {
                return null;
            }
            if (!result.wasResolved()) {
                this.attachResolveError(result, uriFragment.getProxy());
                return null;
            }
            EObject proxy = uriFragment.getProxy();
            this.removeResolveError(result, proxy);
            this.attachResolveWarnings((IJavaReferenceResolveResult<? extends EObject>)result, proxy);
            IJavaReferenceMapping mapping = (IJavaReferenceMapping)result.getMappings().iterator().next();
            EObject resultElement = this.getResultElement(uriFragment, (IJavaReferenceMapping<? extends EObject>)mapping, proxy, result.getErrorMessage());
            this.internalURIFragmentMap.remove(id);
            return resultElement;
        }
        return super.getEObject(id);
    }

    protected EObject getEObject(List<String> uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(size == 0 ? "" : uriFragmentPath.get(0));
        for (int i = 1; i < size && eObject != null; ++i) {
            Object name;
            String uriFragment = uriFragmentPath.get(i);
            if (eObject instanceof MemberContainer && uriFragment.startsWith("@members[name='")) {
                MemberContainer memberContainer = (MemberContainer)eObject;
                name = uriFragment.substring("@members[name='".length(), uriFragment.length() - 2);
                eObject = memberContainer.getContainedClassifier((String)name);
                continue;
            }
            if (eObject instanceof CompilationUnit && uriFragment.startsWith("@classifiers[name='")) {
                CompilationUnit compilationUnit = (CompilationUnit)eObject;
                name = uriFragment.substring("@classifiers[name='".length(), uriFragment.length() - 2);
                eObject = compilationUnit.getContainedClassifier((String)name);
                int j = i + 1;
                while (j < size && eObject == null) {
                    String subUriFragment = uriFragmentPath.get(j);
                    String subName = subUriFragment.substring("@members[name='".length(), subUriFragment.length() - 2);
                    eObject = compilationUnit.getContainedClassifier((String)(name = (String)name + "$" + subName));
                    if (eObject == null) {
                        eObject = compilationUnit.getContainedClassifier(subName);
                    }
                    if (eObject != null) {
                        i = j;
                        continue;
                    }
                    ++j;
                }
                continue;
            }
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment(uriFragmentPath.get(i));
        }
        return eObject;
    }

    private EObject getResultElement(IJavaContextDependentURIFragment uriFragment, IJavaReferenceMapping<? extends EObject> mapping, EObject proxy, String errorMessage) {
        if (mapping instanceof IJavaElementMapping) {
            EObject element = (EObject)((IJavaElementMapping)mapping).getTarget();
            EReference reference = uriFragment.getReference();
            EReference oppositeReference = uriFragment.getReference().getEOpposite();
            if (!uriFragment.getReference().isContainment() && oppositeReference != null) {
                if (reference.isMany()) {
                    EObjectWithInverseResolvingEList.ManyInverse list = (EObjectWithInverseResolvingEList.ManyInverse)element.eGet((EStructuralFeature)oppositeReference, false);
                    list.basicAdd((Object)uriFragment.getContainer(), null);
                } else {
                    uriFragment.getContainer().eSet((EStructuralFeature)uriFragment.getReference(), (Object)element);
                }
            }
            return element;
        }
        assert (false);
        return null;
    }

    private void removeResolveError(IJavaReferenceResolveResult<?> result, EObject proxy) {
        String errorMessage = result.getErrorMessage();
        Iterator iter = this.getErrors().iterator();
        while (iter.hasNext()) {
            Resource.Diagnostic diag = (Resource.Diagnostic)iter.next();
            if (!(diag instanceof SimpleDiagnostic) || ((SimpleDiagnostic)diag).corresponding != proxy) continue;
            iter.remove();
        }
    }

    private void attachResolveError(IJavaReferenceResolveResult<?> result, EObject proxy) {
        assert (result != null);
        String errorMessage = result.getErrorMessage();
        if (errorMessage == null) {
            assert (false);
        } else {
            this.getErrors().add((Object)new SimpleDiagnostic(errorMessage, proxy));
        }
    }

    private void attachResolveWarnings(IJavaReferenceResolveResult<? extends EObject> result, EObject proxy) {
        assert (result != null);
        assert (result.wasResolved());
        if (result.wasResolved()) {
            for (IJavaReferenceMapping mapping : result.getMappings()) {
                String warningMessage = mapping.getWarning();
                if (warningMessage == null) continue;
                this.getWarnings().add((Object)new SimpleDiagnostic(warningMessage));
            }
        }
    }

    public class SimpleDiagnostic
    implements Resource.Diagnostic {
        private String message;
        private EObject corresponding;

        SimpleDiagnostic(String message) {
            this(message, null);
        }

        SimpleDiagnostic(String message, EObject correspond) {
            this.message = message;
            this.corresponding = correspond;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocation() {
            return JavaResource2.this.getURI().toString();
        }

        public int getLine() {
            return 0;
        }

        public int getColumn() {
            return 0;
        }
    }
}

