/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class JavaInterruptibleEcoreResolver {
    private boolean terminate = false;

    public void terminate() {
        this.terminate = true;
    }

    public void resolveAll(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        for (int i = 0; i < resources.size() && !this.terminate; ++i) {
            this.resolveAll((Resource)resources.get(i));
        }
    }

    public void resolveAll(Resource resource) {
        for (EObject eObject : resource.getContents()) {
            if (this.terminate) {
                return;
            }
            this.resolveAll(eObject);
        }
    }

    public void resolveAll(EObject eObject) {
        eObject.eContainer();
        this.resolveCrossReferences(eObject);
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            if (this.terminate) {
                return;
            }
            EObject childEObject = (EObject)i.next();
            this.resolveCrossReferences(childEObject);
        }
    }

    protected void resolveCrossReferences(EObject eObject) {
        Iterator i = eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            if (this.terminate) {
                return;
            }
            i.next();
        }
    }

    public Set<EObject> findUnresolvedProxies(Resource resource) {
        LinkedHashSet<EObject> unresolvedProxies = new LinkedHashSet<EObject>();
        TreeIterator elementIt = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (elementIt.hasNext()) {
            InternalEObject nextElement = (InternalEObject)elementIt.next();
            if (this.terminate) {
                return unresolvedProxies;
            }
            if (nextElement.eIsProxy()) {
                unresolvedProxies.add((EObject)nextElement);
            }
            for (EObject crElement : nextElement.eCrossReferences()) {
                if (this.terminate) {
                    return unresolvedProxies;
                }
                if (!(crElement = EcoreUtil.resolve((EObject)crElement, (Resource)resource)).eIsProxy()) continue;
                unresolvedProxies.add(crElement);
            }
        }
        return unresolvedProxies;
    }

    public Set<EObject> findUnresolvedProxies(ResourceSet resourceSet) {
        LinkedHashSet<EObject> unresolvedProxies = new LinkedHashSet<EObject>();
        for (Resource resource : resourceSet.getResources()) {
            if (this.terminate) {
                return unresolvedProxies;
            }
            unresolvedProxies.addAll(this.findUnresolvedProxies(resource));
        }
        return unresolvedProxies;
    }
}

