/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver.decider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import tools.mdsd.jamopp.resolution.resolver.decider.IResolutionTargetDecider;

public class ScopedTreeWalker {
    protected List<IResolutionTargetDecider> deciderList;
    private EObject currentBestResult = null;
    private boolean finished = false;

    public ScopedTreeWalker(List<IResolutionTargetDecider> deciderList) {
        this.deciderList = deciderList;
    }

    public EObject walk(EObject startingPoint, String identifier, EObject container, EReference crossReference) {
        if (startingPoint == null) {
            return null;
        }
        this.currentBestResult = null;
        this.finished = false;
        for (IResolutionTargetDecider decider : this.deciderList) {
            decider.reset();
            if (decider.canFindTargetsFor(container, crossReference)) continue;
            decider.deactivate();
        }
        this.doWalk(identifier, startingPoint, null, -1);
        for (IResolutionTargetDecider decider : this.deciderList) {
            decider.activate();
        }
        return this.currentBestResult;
    }

    private void doWalk(String identifier, EObject startingPoint, EReference navOrigin, int posInNavOrigin) {
        this.searchInDirectChildren(identifier, startingPoint, navOrigin, posInNavOrigin);
        if (this.finished) {
            return;
        }
        this.searchInAdditionalContent(identifier, startingPoint, navOrigin, posInNavOrigin);
        if (this.finished) {
            return;
        }
        for (IResolutionTargetDecider decider : this.deciderList) {
            if (!decider.isActive()) continue;
            this.walkDown(decider, identifier, startingPoint, navOrigin, posInNavOrigin);
        }
        if (this.finished) {
            return;
        }
        this.walkUp(identifier, startingPoint);
    }

    private void walkUp(String identifier, EObject container) {
        if (container.eContainer() != null) {
            EReference navOrigin = container.eContainmentFeature();
            int posInNavOrigin = 0;
            if (navOrigin.isMany()) {
                EList value = (EList)container.eContainer().eGet((EStructuralFeature)navOrigin);
                posInNavOrigin = value.indexOf((Object)container);
            }
            this.doWalk(identifier, container.eContainer(), navOrigin, posInNavOrigin);
        }
    }

    private void walkDown(IResolutionTargetDecider decider, String identifier, EObject container, EReference navOrigin, int posInNavOrigin) {
        EClass containerClass = container.eClass();
        for (EReference reference : this.getReferences(containerClass)) {
            if (!reference.isContainment()) continue;
            EList<EObject> contentList = null;
            contentList = decider.continueAfterReference() ? this.getContentList(container, reference, null, -1) : this.getContentList(container, reference, navOrigin, posInNavOrigin);
            for (EObject element : contentList) {
                if (!decider.walkInto(element)) continue;
                this.searchInDirectChildren(identifier, element, null, -1);
                this.walkDown(decider, identifier, element, null, -1);
            }
        }
    }

    private void searchInDirectChildren(String identifier, EObject container, EReference navOrigin, int posInNavOrigin) {
        EClass containerClass = container.eClass();
        for (IResolutionTargetDecider decider : this.deciderList) {
            if (!decider.isActive()) continue;
            for (EReference reference : this.getReferences(containerClass)) {
                if (!reference.isContainment() || !decider.containsCandidates(container, reference)) continue;
                EList<EObject> contentList = null;
                contentList = decider.continueAfterReference() ? this.getContentList(container, reference, null, -1) : this.getContentList(container, reference, navOrigin, posInNavOrigin);
                for (EObject element : contentList) {
                    if (!decider.isPossibleTarget(identifier, element)) continue;
                    this.currentBestResult = element;
                }
                if (this.currentBestResult == null || !decider.isSure()) continue;
                this.finished = true;
                return;
            }
        }
    }

    private EList<EReference> getReferences(EClass containerClass) {
        EList references = containerClass.getEAllReferences();
        return references;
    }

    private void searchInAdditionalContent(String identifier, EObject container, EReference navOrigin, int posInNavOrigin) {
        for (IResolutionTargetDecider decider : this.deciderList) {
            EList<? extends EObject> additionalCandidates;
            if (!decider.isActive() || (additionalCandidates = decider.getAdditionalCandidates(identifier, container)) == null) continue;
            for (EObject element : additionalCandidates) {
                if (!decider.isPossibleTarget(identifier, element)) continue;
                this.currentBestResult = element;
                if (!decider.isSure()) continue;
                this.finished = true;
                return;
            }
        }
    }

    private EList<EObject> getContentList(EObject container, EReference reference, EReference navOrigin, int posInNavOrigin) {
        BasicEList contentList = new BasicEList();
        if (!reference.isMany()) {
            EObject value = (EObject)container.eGet((EStructuralFeature)reference);
            contentList.add((Object)value);
        } else {
            EList value = (EList)container.eGet((EStructuralFeature)reference);
            if (!reference.equals(navOrigin)) {
                contentList.addAll((Collection)value);
            } else {
                contentList.addAll((Collection)value.subList(0, posInNavOrigin + 1));
            }
        }
        return contentList;
    }
}

