/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver.decider;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.PackageReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.references.ReferencesPackage;
import tools.mdsd.jamopp.resolution.resolver.decider.AbstractDecider;

public class PackageDecider
extends AbstractDecider {
    @Override
    public boolean canFindTargetsFor(EObject referenceContainer, EReference crossReference) {
        if (referenceContainer instanceof IdentifierReference) {
            IdentifierReference idReference = (IdentifierReference)referenceContainer;
            if (!(idReference.getNext() instanceof IdentifierReference)) {
                return false;
            }
            if (!referenceContainer.eContainingFeature().equals(ReferencesPackage.Literals.REFERENCE__NEXT)) {
                return true;
            }
            if (referenceContainer.eContainingFeature().equals(ReferencesPackage.Literals.REFERENCE__NEXT) && idReference.eContainer() instanceof IdentifierReference) {
                return true;
            }
        }
        return false;
    }

    @Override
    public EList<? extends EObject> getAdditionalCandidates(String identifier, EObject container) {
        if (container instanceof IdentifierReference) {
            BasicEList resultList = new BasicEList();
            IdentifierReference parentPackage = (IdentifierReference)container;
            Object pack = parentPackage.getTarget().getName();
            Reference parent = parentPackage.getPrevious();
            if (parent != null) {
                if (!(parent instanceof IdentifierReference)) {
                    return resultList;
                }
                IdentifierReference parentCast = (IdentifierReference)parent;
                if (parentCast.getTarget() instanceof Package) {
                    pack = ((Package)parentCast.getTarget()).getNamespacesAsString() + (String)pack;
                } else if (parentCast.getTarget() instanceof PackageReference) {
                    PackageReference packRef = (PackageReference)parentCast.getTarget();
                    pack = packRef.getNamespacesAsString() + packRef.getName() + "." + (String)pack;
                } else {
                    return resultList;
                }
            }
            if (JavaClasspath.get((EObject)container).isPackageRegistered((String)pack)) {
                Package p = JavaClasspath.get((EObject)container).getPackage((String)pack);
                if (p != null) {
                    resultList.add((Object)p);
                } else {
                    PackageReference pr = ReferencesFactory.eINSTANCE.createPackageReference();
                    for (String namespace : ((String)pack).split("\\.")) {
                        pr.getNamespaces().add((Object)namespace);
                    }
                    pr.getNamespaces().remove(pr.getNamespaces().size() - 1);
                    pr.setName(identifier);
                    resultList.add((Object)pr);
                }
            }
            return resultList;
        }
        if (container instanceof JavaRoot && container.eResource() != null) {
            BasicEList resultList = new BasicEList();
            if (JavaClasspath.get((EObject)container).isPackageRegistered(((JavaRoot)container).getNamespacesAsString() + identifier)) {
                PackageReference p = ReferencesFactory.eINSTANCE.createPackageReference();
                p.setName(identifier);
                resultList.add((Object)p);
            }
            return resultList;
        }
        return null;
    }

    @Override
    public boolean containsCandidates(EObject container, EReference containingReference) {
        return false;
    }

    @Override
    public boolean isPossibleTarget(String id, EObject element) {
        if (element instanceof Package) {
            Package ne = (Package)element;
            return id.equals(ne.getNamespaces().get(ne.getNamespaces().size() - 1));
        }
        if (element instanceof PackageReference) {
            return id.equals(((PackageReference)element).getName());
        }
        return false;
    }
}

