/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver.decider;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportingElement;
import tools.mdsd.jamopp.model.java.imports.StaticClassifierImport;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.resolution.resolver.decider.AbstractDecider;

public class MethodDecider
extends AbstractDecider {
    protected MethodCall methodCall = null;
    protected Method lastFound = null;
    private boolean insideDefiningClassifier = true;
    private boolean isStatic = false;

    @Override
    public boolean canFindTargetsFor(EObject referenceContainer, EReference containingReference) {
        if (referenceContainer instanceof MethodCall) {
            this.methodCall = (MethodCall)referenceContainer;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.insideDefiningClassifier = true;
        this.lastFound = null;
    }

    @Override
    public EList<? extends EObject> getAdditionalCandidates(String identifier, EObject container) {
        EList memberList;
        BasicEList resultList = new BasicEList();
        if (container instanceof Classifier) {
            if (container instanceof ConcreteClassifier && this.insideDefiningClassifier) {
                memberList = ((Classifier)container).getAllMembers((Commentable)this.methodCall);
                for (Member member : memberList) {
                    if (!(member instanceof Method)) continue;
                    resultList.add((Object)member);
                }
                this.insideDefiningClassifier = false;
                this.isStatic = ((ConcreteClassifier)container).isStatic();
            } else {
                memberList = ((Classifier)container).getAllMembers((Commentable)this.methodCall);
                for (Member member : memberList) {
                    if (!(member instanceof Method) || this.isStatic && !((Method)member).isStatic()) continue;
                    resultList.add((Object)member);
                }
            }
        }
        if (container instanceof AnonymousClass) {
            resultList.addAll((Collection)((AnonymousClass)container).getMembers());
            memberList = ((AnonymousClass)container).getAllMembers((Commentable)this.methodCall);
            for (Member member : memberList) {
                if (!(member instanceof Method)) continue;
                resultList.add((Object)member);
            }
            return resultList;
        }
        if (container instanceof CompilationUnit) {
            this.addImports(container, (EList<EObject>)resultList);
        }
        return resultList;
    }

    private void addImports(EObject container, EList<EObject> resultList) {
        if (container instanceof ImportingElement) {
            for (Import aImport : ((ImportingElement)container).getImports()) {
                if (aImport instanceof StaticMemberImport) {
                    StaticMemberImport staticMemberImport = (StaticMemberImport)aImport;
                    if (!staticMemberImport.getStaticMembers().isEmpty()) {
                        staticMemberImport.getStaticMembers().get(0);
                    }
                    resultList.addAll((Collection)staticMemberImport.getStaticMembers());
                    continue;
                }
                if (!(aImport instanceof StaticClassifierImport)) continue;
                resultList.addAll((Collection)aImport.getImportedMembers());
            }
        }
    }

    @Override
    public boolean isPossibleTarget(String id, EObject element) {
        Method method;
        if (element instanceof Method && id.equals((method = (Method)element).getName())) {
            if (this.lastFound == null) {
                if (method.isSomeMethodForCall(this.methodCall)) {
                    this.lastFound = method;
                    return true;
                }
            } else if (!this.lastFound.equals(method) && method.isBetterMethodForCall(this.lastFound, this.methodCall)) {
                this.lastFound = method;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSure() {
        return false;
    }

    @Override
    public boolean containsCandidates(EObject container, EReference containingReference) {
        return false;
    }
}

