/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver.decider;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportingElement;
import tools.mdsd.jamopp.model.java.imports.StaticClassifierImport;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.resolution.resolver.decider.AbstractDecider;

public class FieldDecider
extends AbstractDecider {
    private Field standardArrayLengthField = null;
    private Reference fieldReference = null;
    private boolean insideDefiningClassifier = true;
    private boolean isStatic = false;

    public Field getArrayLengthFiled(Commentable objectContext) {
        if (this.standardArrayLengthField == null) {
            this.standardArrayLengthField = MembersFactory.eINSTANCE.createField();
            this.standardArrayLengthField.setName("length");
            ClassifierReference typeReference = TypesFactory.eINSTANCE.createClassifierReference();
            typeReference.setTarget((Classifier)objectContext.getLibClass("Integer"));
            this.standardArrayLengthField.setTypeReference((TypeReference)typeReference);
        }
        return this.standardArrayLengthField;
    }

    @Override
    public void reset() {
        this.insideDefiningClassifier = true;
    }

    @Override
    public EList<? extends EObject> getAdditionalCandidates(String identifier, EObject container) {
        EList memberList;
        BasicEList resultList = new BasicEList();
        if (container instanceof Classifier) {
            if (container instanceof ConcreteClassifier && this.insideDefiningClassifier) {
                memberList = ((Classifier)container).getAllMembers((Commentable)this.fieldReference);
                for (Member member : memberList) {
                    if (!(member instanceof Field)) continue;
                    resultList.add((Object)member);
                    resultList.addAll((Collection)((Field)member).getAdditionalFields());
                }
                this.insideDefiningClassifier = false;
                this.isStatic = ((ConcreteClassifier)container).isStatic();
            } else {
                memberList = ((Classifier)container).getAllMembers((Commentable)this.fieldReference);
                for (Member member : memberList) {
                    if (!(member instanceof Field) || this.isStatic && !((Field)member).isStatic()) continue;
                    resultList.add((Object)member);
                    resultList.addAll((Collection)((Field)member).getAdditionalFields());
                }
            }
        }
        if (container instanceof AnonymousClass) {
            resultList.addAll((Collection)((AnonymousClass)container).getMembers());
            memberList = ((AnonymousClass)container).getAllMembers((Commentable)this.fieldReference);
            for (Member member : memberList) {
                if (!(member instanceof Field)) continue;
                resultList.add((Object)member);
                resultList.addAll((Collection)((Field)member).getAdditionalFields());
            }
            return resultList;
        }
        if (container instanceof CompilationUnit) {
            this.addImports(container, (EList<EObject>)resultList);
            this.addArrayLengthField((EList<EObject>)resultList, (Commentable)((CompilationUnit)container));
        }
        return resultList;
    }

    private void addArrayLengthField(EList<EObject> resultList, Commentable objectContext) {
        resultList.add((Object)this.getArrayLengthFiled(objectContext));
    }

    private void addImports(EObject container, EList<EObject> resultList) {
        if (container instanceof ImportingElement) {
            for (Import aImport : ((ImportingElement)container).getImports()) {
                if (aImport instanceof StaticMemberImport) {
                    resultList.addAll((Collection)((StaticMemberImport)aImport).getStaticMembers());
                    continue;
                }
                if (!(aImport instanceof StaticClassifierImport)) continue;
                resultList.addAll((Collection)aImport.getImportedMembers());
            }
        }
    }

    @Override
    public boolean isPossibleTarget(String id, EObject element) {
        if (element instanceof Field || element instanceof AdditionalField) {
            NamedElement ne = (NamedElement)element;
            return id.equals(ne.getName());
        }
        return false;
    }

    @Override
    public boolean containsCandidates(EObject container, EReference containingReference) {
        return false;
    }

    @Override
    public boolean walkInto(EObject element) {
        return false;
    }

    @Override
    public boolean canFindTargetsFor(EObject referenceContainer, EReference containingReference) {
        if (referenceContainer instanceof MethodCall) {
            return false;
        }
        if (!(referenceContainer instanceof Reference)) {
            return false;
        }
        Reference reference = (Reference)referenceContainer;
        if (reference.getNext() instanceof ReflectiveClassReference) {
            return false;
        }
        if (reference.getNext() instanceof SelfReference) {
            return false;
        }
        this.fieldReference = (Reference)referenceContainer;
        return true;
    }
}

