/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver.decider;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersPackage;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.expressions.AssignmentExpression;
import tools.mdsd.jamopp.model.java.imports.ClassifierImport;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportingElement;
import tools.mdsd.jamopp.model.java.imports.StaticClassifierImport;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.statements.StatementsPackage;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SwitchCase;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.util.TemporalCompositeClassifier;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.resolution.resolver.decider.AbstractDecider;

public class EnumConstantDecider
extends AbstractDecider {
    private EObject reference = null;

    @Override
    public boolean isPossibleTarget(String id, EObject element) {
        if (element instanceof EnumConstant) {
            NamedElement ne = (NamedElement)element;
            return id.equals(ne.getName());
        }
        return false;
    }

    @Override
    public EList<? extends EObject> getAdditionalCandidates(String identifier, EObject container) {
        LocalVariable localVariable;
        AssignmentExpression assignmentExpression;
        Type assignmentExpressionType;
        if (container instanceof Switch && (this.reference.eContainmentFeature().equals(StatementsPackage.Literals.CONDITIONAL__CONDITION) && this.reference.eContainer() instanceof SwitchCase || (this.reference.eContainmentFeature().equals(StatementsPackage.Literals.NORMAL_SWITCH_CASE__ADDITIONAL_CONDITIONS) || this.reference.eContainmentFeature().equals(StatementsPackage.Literals.NORMAL_SWITCH_RULE__ADDITIONAL_CONDITIONS)) && this.reference.eContainer() instanceof SwitchCase)) {
            Switch aSwitch = (Switch)container;
            Type variableType = aSwitch.getVariable().getType();
            if (variableType instanceof Enumeration) {
                return ((Enumeration)variableType).getConstants();
            }
            if (variableType instanceof TemporalCompositeClassifier) {
                for (EObject superType : ((TemporalCompositeClassifier)variableType).getSuperTypes()) {
                    if (!(superType instanceof Enumeration)) continue;
                    return ((Enumeration)superType).getConstants();
                }
            }
        }
        if (container instanceof AssignmentExpression && (assignmentExpressionType = (assignmentExpression = (AssignmentExpression)container).getType()) instanceof Enumeration) {
            return ((Enumeration)assignmentExpressionType).getConstants();
        }
        if (container instanceof LocalVariable && (assignmentExpressionType = (localVariable = (LocalVariable)container).getTypeReference().getTarget()) instanceof Enumeration) {
            return ((Enumeration)assignmentExpressionType).getConstants();
        }
        EList<EObject> resultList = this.addImports(container);
        return resultList;
    }

    private EList<EObject> addImports(EObject container) {
        if (container instanceof ImportingElement) {
            BasicEList resultList = new BasicEList();
            for (Import aImport : ((ImportingElement)container).getImports()) {
                if (aImport instanceof StaticMemberImport) {
                    resultList.addAll((Collection)((StaticMemberImport)aImport).getStaticMembers());
                    continue;
                }
                if (aImport instanceof StaticClassifierImport) {
                    resultList.addAll((Collection)aImport.getImportedMembers());
                    continue;
                }
                if (!(aImport instanceof ClassifierImport)) continue;
                for (EObject member : ((ClassifierImport)aImport).getClassifier().getMembers()) {
                    if (!(member instanceof AnnotableAndModifiable) || !((AnnotableAndModifiable)member).isStatic()) continue;
                    resultList.add((Object)member);
                }
            }
            return resultList;
        }
        return null;
    }

    @Override
    public boolean containsCandidates(EObject container, EReference containingReference) {
        return ClassifiersPackage.Literals.ENUMERATION__CONSTANTS.equals(containingReference);
    }

    @Override
    public boolean canFindTargetsFor(EObject referenceContainer, EReference containingReference) {
        this.reference = referenceContainer;
        return referenceContainer instanceof Reference && !(referenceContainer instanceof MethodCall);
    }
}

