/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver.decider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.imports.ClassifierImport;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportingElement;
import tools.mdsd.jamopp.model.java.imports.PackageImport;
import tools.mdsd.jamopp.model.java.imports.StaticClassifierImport;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.PackageReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.statements.StatementsPackage;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.resolution.resolver.decider.AbstractDecider;
import tools.mdsd.jamopp.resolution.resolver.decider.ScopedTreeWalker;
import tools.mdsd.jamopp.resolution.resolver.decider.TypeParameterDecider;

public class ConcreteClassifierDecider
extends AbstractDecider {
    private EList<ConcreteClassifier> innerTypeSuperTypeList = new BasicEList();
    private Commentable reference = null;
    private static ScopedTreeWalker relativeNamespaceResolutionWalker = new ScopedTreeWalker(List.of(new ConcreteClassifierDecider(), new TypeParameterDecider()));

    @Override
    public void reset() {
        this.innerTypeSuperTypeList.clear();
    }

    @Override
    public boolean containsCandidates(EObject container, EReference containingReference) {
        if (StatementsPackage.Literals.STATEMENT_CONTAINER__STATEMENT.equals(containingReference)) {
            return true;
        }
        return StatementsPackage.Literals.BLOCK__STATEMENTS.equals(containingReference) || StatementsPackage.Literals.SWITCH_CASE__STATEMENTS.equals(containingReference);
    }

    @Override
    public EList<? extends EObject> getAdditionalCandidates(String identifier, EObject container) {
        BasicEList resultList = new BasicEList();
        if (container instanceof IdentifierReference) {
            IdentifierReference p = (IdentifierReference)container;
            String packageName = this.packageName(p);
            resultList.addAll(JavaClasspath.get((EObject)container).getConcreteClassifiers(packageName));
        }
        if (container instanceof Classifier) {
            Classifier classifier = (Classifier)container;
            resultList.add((Object)classifier);
            if (!classifier.eIsProxy()) {
                for (Member member : classifier.getAllMembers(this.reference)) {
                    if (!(member instanceof ConcreteClassifier)) continue;
                    this.innerTypeSuperTypeList.add((Object)((ConcreteClassifier)member));
                }
                if (classifier instanceof ConcreteClassifier) {
                    this.innerTypeSuperTypeList.addAll((Collection)((ConcreteClassifier)classifier).getAllInnerClassifiers());
                    Object cqualifiedName = ((ConcreteClassifier)classifier).getQualifiedName();
                    cqualifiedName = JavaClasspath.get((EObject)container).isPackageRegistered((String)cqualifiedName + "$") ? (String)cqualifiedName + "$" + identifier : (String)cqualifiedName + "." + identifier;
                    ConcreteClassifier cc = JavaClasspath.get((EObject)container).getConcreteClassifier((String)cqualifiedName);
                    if (cc.eIsProxy()) {
                        if (!(cc = (ConcreteClassifier)EcoreUtil.resolve((EObject)cc, (EObject)classifier)).eIsProxy()) {
                            resultList.add((Object)cc);
                        }
                    } else {
                        resultList.add((Object)cc);
                    }
                }
            }
        }
        if (container instanceof AnonymousClass) {
            for (Member member : ((AnonymousClass)container).getAllMembers(this.reference)) {
                if (!(member instanceof ConcreteClassifier)) continue;
                this.innerTypeSuperTypeList.add((Object)((ConcreteClassifier)member));
            }
            ConcreteClassifier superClassifier = ((AnonymousClass)container).getSuperClassifier();
            if (superClassifier != null) {
                this.innerTypeSuperTypeList.addAll((Collection)superClassifier.getAllInnerClassifiers());
            }
        }
        this.addImportsAndInnerClasses(container, (EList<EObject>)resultList);
        return resultList;
    }

    private String packageName(IdentifierReference p) {
        Reference previous = p.getPrevious();
        Object s = "";
        if (previous instanceof IdentifierReference) {
            p = (IdentifierReference)previous;
        } else {
            return s;
        }
        while (p != null) {
            if (p.getTarget() instanceof Package) {
                s = ((Package)p.getTarget()).getNamespacesAsString();
                break;
            }
            if (p.getTarget() instanceof PackageReference) {
                PackageReference ref = (PackageReference)p.getTarget();
                s = ref.getNamespacesAsString() + ref.getName() + "." + (String)s;
                break;
            }
            s = p.getTarget().getName() + "." + (String)s;
            EObject container = p.eContainer();
            if (container instanceof IdentifierReference) {
                p = (IdentifierReference)container;
                continue;
            }
            p = null;
        }
        return s;
    }

    private void addImportsAndInnerClasses(EObject container, EList<EObject> resultList) {
        if (container instanceof JavaRoot) {
            resultList.addAll(this.innerTypeSuperTypeList);
        }
        if (container instanceof ImportingElement) {
            for (Import aImport : ((ImportingElement)container).getImports()) {
                if (aImport instanceof ClassifierImport) {
                    resultList.add((Object)((ClassifierImport)aImport).getClassifier());
                    continue;
                }
                if (aImport instanceof StaticMemberImport) {
                    StaticMemberImport staticMemberImport = (StaticMemberImport)aImport;
                    if (!staticMemberImport.getStaticMembers().isEmpty()) {
                        staticMemberImport.getStaticMembers().get(0);
                    }
                    resultList.addAll((Collection)staticMemberImport.getStaticMembers());
                    continue;
                }
                if (!(aImport instanceof StaticClassifierImport)) continue;
                resultList.addAll((Collection)aImport.getImportedMembers());
            }
        }
        if (container instanceof JavaRoot) {
            resultList.addAll((Collection)((JavaRoot)container).getClassifiersInSamePackage());
        }
        if (container instanceof ImportingElement) {
            BasicEList packageImports = new BasicEList();
            for (Import aImport : ((ImportingElement)container).getImports()) {
                if (!(aImport instanceof PackageImport)) continue;
                packageImports.addAll((Collection)aImport.getImportedClassifiers());
            }
            resultList.addAll((Collection)packageImports);
        }
        if (container instanceof JavaRoot || container.eContainer() == null) {
            resultList.addAll(JavaClasspath.get((EObject)container).getConcreteClassifiers("java.lang"));
        }
    }

    @Override
    public boolean isPossibleTarget(String id, EObject element) {
        if (element instanceof ConcreteClassifier) {
            String lastSegment;
            ConcreteClassifier concreteClassifier = (ConcreteClassifier)element;
            if (id.equals(concreteClassifier.getName())) {
                return true;
            }
            if (element.eIsProxy() && ((lastSegment = ((InternalEObject)element).eProxyURI().lastSegment()).endsWith("." + id + ".java") || lastSegment.equals(id + ".java"))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canFindTargetsFor(EObject referenceContainer, EReference crossReference) {
        if (!(referenceContainer instanceof Commentable)) {
            return false;
        }
        if (referenceContainer instanceof MethodCall) {
            return false;
        }
        this.reference = (Commentable)referenceContainer;
        return referenceContainer instanceof Reference || referenceContainer instanceof ClassifierReference;
    }

    public static EObject resolveRelativeNamespace(NamespaceAwareElement nsaElement, int idx, EObject startingPoint, EObject referenceContainer, EReference crossReference) {
        if (idx < nsaElement.getNamespaces().size()) {
            String identifier = (String)nsaElement.getNamespaces().get(idx);
            EObject target = null;
            if (idx == 0) {
                target = relativeNamespaceResolutionWalker.walk(startingPoint, identifier, referenceContainer, crossReference);
            } else {
                for (ConcreteClassifier cand : ((ConcreteClassifier)startingPoint).getAllInnerClassifiers()) {
                    if (!identifier.equals(cand.getName())) continue;
                    target = cand;
                    break;
                }
            }
            if (target != null) {
                if (target.eIsProxy()) {
                    target = EcoreUtil.resolve((EObject)target, (EObject)referenceContainer);
                }
                return ConcreteClassifierDecider.resolveRelativeNamespace(nsaElement, idx + 1, target, referenceContainer, crossReference);
            }
            return null;
        }
        return startingPoint;
    }
}

