/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.resolution.resolver.IJavaReferenceResolver;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaReferenceResolveResult;

public class StaticMemberImportStaticMembersReferenceResolver
implements IJavaReferenceResolver<StaticMemberImport, ReferenceableElement> {
    @Override
    public void resolve(String identifier, StaticMemberImport theImport, EReference reference, int position, IJavaReferenceResolveResult<ReferenceableElement> result) {
        ConcreteClassifier classifier = theImport.getClassifier();
        if (classifier.eIsProxy()) {
            classifier = (ConcreteClassifier)EcoreUtil.resolve((EObject)classifier, (Resource)theImport.eResource());
        }
        if (classifier != null && !classifier.eIsProxy()) {
            for (Member member : classifier.getAllMembers((Commentable)theImport)) {
                if (!identifier.equals(member.getName()) || !(member instanceof ReferenceableElement) || !(member instanceof AnnotableAndModifiable)) continue;
                if (member.eIsProxy()) {
                    member = (Member)EcoreUtil.resolve((EObject)member, (EObject)theImport);
                }
                if (!((AnnotableAndModifiable)member).isStatic()) continue;
                result.addMapping(identifier, (ReferenceableElement)member);
            }
            if (classifier instanceof Enumeration) {
                for (EnumConstant enumConstant : ((Enumeration)classifier).getConstants()) {
                    if (!identifier.equals(enumConstant.getName())) continue;
                    result.addMapping(identifier, (ReferenceableElement)enumConstant);
                    return;
                }
            }
        }
    }
}

