/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragment;
import tools.mdsd.jamopp.resolution.bindings.CentralBindingBasedResolver;
import tools.mdsd.jamopp.resolution.resolver.IJavaReferenceResolver;
import tools.mdsd.jamopp.resolution.resolver.JavaReferenceResolverSwitch;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaElementMapping;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaReferenceMapping;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaReferenceResolveResult;
import tools.mdsd.jamopp.resolution.resolver.result.JavaReferenceResolveResult;

public class CentralReferenceResolver {
    public static final CentralReferenceResolver GLOBAL_INSTANCE = new CentralReferenceResolver();
    private IJavaReferenceResolver<EObject, EObject> resolver = new JavaReferenceResolverSwitch();
    private HashSet<IJavaContextDependentURIFragment> resolving = new HashSet();
    private CentralBindingBasedResolver bindingResolver;

    public void setBindingBasedResolver(CentralBindingBasedResolver resolver) {
        this.bindingResolver = resolver;
    }

    public IJavaReferenceResolveResult<EObject> resolve(IJavaContextDependentURIFragment context) {
        if (this.resolving.contains(context)) {
            return null;
        }
        this.resolving.add(context);
        JavaReferenceResolveResult<EObject> result = new JavaReferenceResolveResult<EObject>();
        result.setErrorMessage(this.getStdErrorMessage(context));
        if (this.bindingResolver != null) {
            EObject resolved = this.bindingResolver.resolve(context.getBinding());
            if (resolved == null) {
                this.resolving.remove(context);
                return null;
            }
            result.addMapping(context.getIdentifier(), resolved);
        } else {
            this.resolver.resolve(context.getIdentifier(), context.getContainer(), context.getReference(), context.getPositionInReference(), result);
        }
        if (result.wasResolvedMultiple()) {
            this.handleMultipleResults(context, result);
        }
        this.resolving.remove(context);
        return result;
    }

    private void handleMultipleResults(IJavaContextDependentURIFragment context, IJavaReferenceResolveResult<EObject> result) {
        EList list = null;
        Object temp = context.getContainer().eGet((EStructuralFeature)context.getReference());
        if (temp instanceof EList) {
            list = (EList)temp;
        }
        boolean first = true;
        for (IJavaReferenceMapping<EObject> mapping : result.getMappings()) {
            if (first) {
                first = false;
                continue;
            }
            if (list != null) {
                this.addResultToList(mapping, context.getProxy(), (EList<EObject>)list);
                continue;
            }
            throw new IllegalArgumentException(context.getContainer().eClass().getName() + "." + context.getReference().getName() + " has multiplicity 1, but was resolved to multiple elements.", null);
        }
    }

    private void addResultToList(IJavaReferenceMapping<? extends EObject> mapping, EObject proxy, EList<EObject> list) {
        EObject target = null;
        int proxyPosition = list.indexOf((Object)proxy);
        if (mapping instanceof IJavaElementMapping) {
            target = (EObject)((IJavaElementMapping)mapping).getTarget();
        }
        try {
            if (proxyPosition + 1 == list.size()) {
                list.add((Object)target);
            } else {
                list.add(proxyPosition + 1, (Object)target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getStdErrorMessage(IJavaContextDependentURIFragment context) {
        String typeName = context.getReference().getEType().getName();
        String msg = typeName + " '" + context.getIdentifier() + "' not declared";
        return msg;
    }
}

