/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.resolver;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.resolution.resolver.IJavaReferenceResolver;
import tools.mdsd.jamopp.resolution.resolver.decider.ConcreteClassifierDecider;
import tools.mdsd.jamopp.resolution.resolver.decider.ScopedTreeWalker;
import tools.mdsd.jamopp.resolution.resolver.result.IJavaReferenceResolveResult;

public class AnnotationInstanceAnnotationReferenceResolver
implements IJavaReferenceResolver<AnnotationInstance, Classifier> {
    @Override
    public void resolve(String identifier, AnnotationInstance annotationInstance, EReference reference, int position, IJavaReferenceResolveResult<Classifier> result) {
        AnnotationInstance startingPoint = annotationInstance;
        EObject target = null;
        if (annotationInstance.getNamespaces().size() > 0) {
            EObject lastClassInNS = ConcreteClassifierDecider.resolveRelativeNamespace((NamespaceAwareElement)annotationInstance, 0, (EObject)annotationInstance, (EObject)annotationInstance, reference);
            if (lastClassInNS != null) {
                startingPoint = lastClassInNS;
            } else {
                target = this.resolveFullQualifiedAnnotationReferences(identifier, annotationInstance);
            }
        }
        if (target == null) {
            ScopedTreeWalker resolutionWalker = new ScopedTreeWalker(List.of(new ConcreteClassifierDecider()));
            target = resolutionWalker.walk((EObject)startingPoint, identifier, (EObject)annotationInstance, reference);
        }
        if (target != null) {
            result.addMapping(identifier, (Classifier)target);
        }
    }

    private EObject resolveFullQualifiedAnnotationReferences(String identifier, AnnotationInstance annotationInstance) {
        if (annotationInstance.getNamespaces().size() > 0) {
            String containerName = annotationInstance.getNamespacesAsString();
            ConcreteClassifier target = (ConcreteClassifier)EcoreUtil.resolve((EObject)JavaClasspath.get((EObject)annotationInstance).getConcreteClassifier(containerName + identifier), (Resource)annotationInstance.eResource());
            if (target instanceof Annotation) {
                return target;
            }
        }
        return null;
    }
}

