/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.bindings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameter;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameterList;
import tools.mdsd.jamopp.model.java.annotations.AnnotationValue;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsFactory;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializationValue;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializer;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.arrays.ArraysFactory;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersPackage;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.ContainersPackage;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Origin;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpression;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.literals.BooleanLiteral;
import tools.mdsd.jamopp.model.java.literals.CharacterLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.NullLiteral;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.Default;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modules.ExportsModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ModuleReference;
import tools.mdsd.jamopp.model.java.modules.ModulesFactory;
import tools.mdsd.jamopp.model.java.modules.ModulesPackage;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.references.ReferencesPackage;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.model.java.types.TypesPackage;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragmentCollector;

public class JDTBindingConverterUtility {
    public static List<TypeReference> convertToTypeReferences(ITypeBinding binding) {
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        if (binding.isPrimitive()) {
            if (binding.getName().equals("int")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createInt());
            } else if (binding.getName().equals("byte")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createByte());
            } else if (binding.getName().equals("short")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createShort());
            } else if (binding.getName().equals("long")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createLong());
            } else if (binding.getName().equals("boolean")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createBoolean());
            } else if (binding.getName().equals("double")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createDouble());
            } else if (binding.getName().equals("float")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createFloat());
            } else if (binding.getName().equals("void")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createVoid());
            } else if (binding.getName().equals("char")) {
                result.add((TypeReference)TypesFactory.eINSTANCE.createChar());
            }
        } else {
            if (binding.isArray()) {
                return JDTBindingConverterUtility.convertToTypeReferences(binding.getElementType());
            }
            if (binding.isIntersectionType()) {
                for (ITypeBinding b : binding.getTypeBounds()) {
                    result.addAll(JDTBindingConverterUtility.convertToTypeReferences(b));
                }
            } else {
                String qualifiedName = binding.getQualifiedName();
                if (qualifiedName != null && !qualifiedName.equals("") && qualifiedName.contains(".")) {
                    NamespaceClassifierReference parentRef = TypesFactory.eINSTANCE.createNamespaceClassifierReference();
                    int index = qualifiedName.indexOf("<");
                    if (index > -1) {
                        qualifiedName = qualifiedName.substring(0, index);
                    }
                    if ((index = qualifiedName.indexOf("[")) > -1) {
                        qualifiedName = qualifiedName.substring(0, index);
                    }
                    String[] nameParts = qualifiedName.split("\\.");
                    for (index = 0; index < nameParts.length - 1; ++index) {
                        parentRef.getNamespaces().add((Object)nameParts[index]);
                    }
                    parentRef.getClassifierReferences().add((Object)JDTBindingConverterUtility.convertToClassifierReference(binding));
                    result.add((TypeReference)parentRef);
                } else {
                    result.add((TypeReference)JDTBindingConverterUtility.convertToClassifierReference(binding));
                }
            }
        }
        return result;
    }

    private static ClassifierReference convertToClassifierReference(ITypeBinding binding) {
        ClassifierReference ref = TypesFactory.eINSTANCE.createClassifierReference();
        Class classifier = ClassifiersFactory.eINSTANCE.createClass();
        JDTBindingConverterUtility.convertToNameAndSet(binding, (NamedElement)classifier);
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(ref, TypesPackage.Literals.CLASSIFIER_REFERENCE__TARGET, classifier.getName(), (EObject)classifier, -1, (IBinding)binding);
        if (binding.isParameterizedType()) {
            for (ITypeBinding b : binding.getTypeArguments()) {
                ref.getTypeArguments().add((Object)JDTBindingConverterUtility.convertToTypeArgument(b));
            }
        }
        ref.setTarget((Classifier)classifier);
        return ref;
    }

    private static void convertToNameAndSet(ITypeBinding binding, NamedElement element) {
        String name = binding.getName();
        if (binding.isParameterizedType()) {
            name = name.substring(0, name.indexOf("<"));
        } else if (binding.isArray()) {
            name = name.substring(0, name.indexOf("["));
        }
        element.setName(name);
    }

    private static TypeArgument convertToTypeArgument(ITypeBinding binding) {
        if (binding.isWildcardType()) {
            if (binding.getBound() == null) {
                return GenericsFactory.eINSTANCE.createUnknownTypeArgument();
            }
            if (binding.isUpperbound()) {
                ExtendsTypeArgument result = GenericsFactory.eINSTANCE.createExtendsTypeArgument();
                result.setExtendType(JDTBindingConverterUtility.convertToTypeReferences(binding.getBound()).get(0));
                JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)result, false);
                return result;
            }
            SuperTypeArgument result = GenericsFactory.eINSTANCE.createSuperTypeArgument();
            result.setSuperType(JDTBindingConverterUtility.convertToTypeReferences(binding.getBound()).get(0));
            JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)result, false);
            return result;
        }
        QualifiedTypeArgument result = GenericsFactory.eINSTANCE.createQualifiedTypeArgument();
        result.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(binding).get(0));
        JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)result, false);
        return result;
    }

    private static void convertToArrayDimensionsAndSet(ITypeBinding binding, ArrayTypeable arrDimContainer, boolean isVarArg) {
        if (binding.isArray()) {
            int i;
            int n = i = isVarArg ? 1 : 0;
            while (i < binding.getDimensions()) {
                arrDimContainer.getArrayDimensionsBefore().add((Object)ArraysFactory.eINSTANCE.createArrayDimension());
                ++i;
            }
        }
    }

    static CompilationUnit convertToCompilationUnit(ITypeBinding binding) {
        binding = binding.getTypeDeclaration();
        CompilationUnit result = ContainersFactory.eINSTANCE.createCompilationUnit();
        result.setOrigin(Origin.BINDING);
        result.setName(binding.getName());
        JDTBindingConverterUtility.convertIPackageNameComponentsToNamespaces(binding.getPackage(), (NamespaceAwareElement)result);
        result.getClassifiers().add((Object)JDTBindingConverterUtility.convertToConcreteClassifier(binding));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static ConcreteClassifier convertToConcreteClassifier(ITypeBinding binding) {
        int n;
        IAnnotationBinding[] result = null;
        if (binding.isAnnotation()) {
            result = ClassifiersFactory.eINSTANCE.createAnnotation();
        } else if (binding.isClass()) {
            Class resultClass = ClassifiersFactory.eINSTANCE.createClass();
            if (resultClass.eContainer() == null) {
                try {
                    void var5_13;
                    if (binding.getSuperclass() != null) {
                        resultClass.setExtends(JDTBindingConverterUtility.convertToTypeReferences(binding.getSuperclass()).get(0));
                    }
                    var3_5 = binding.getInterfaces();
                    n = var3_5.length;
                    boolean bl = false;
                    while (var5_13 < n) {
                        ITypeBinding iTypeBinding = var3_5[var5_13];
                        resultClass.getImplements().addAll(JDTBindingConverterUtility.convertToTypeReferences(iTypeBinding));
                        ++var5_13;
                    }
                }
                catch (AbortCompilation abortCompilation) {
                    // empty catch block
                }
            }
            result = resultClass;
        } else if (binding.isInterface()) {
            Interface resultInterface = ClassifiersFactory.eINSTANCE.createInterface();
            if (resultInterface.eContainer() == null) {
                try {
                    void var5_15;
                    var3_5 = binding.getInterfaces();
                    n = var3_5.length;
                    boolean bl = false;
                    while (var5_15 < n) {
                        ITypeBinding iTypeBinding = var3_5[var5_15];
                        resultInterface.getExtends().addAll(JDTBindingConverterUtility.convertToTypeReferences(iTypeBinding));
                        ++var5_15;
                    }
                }
                catch (AbortCompilation abortCompilation) {
                    // empty catch block
                }
            }
            result = resultInterface;
        } else {
            IAnnotationBinding[] resultEnum = ClassifiersFactory.eINSTANCE.createEnumeration();
            if (resultEnum.eContainer() == null) {
                try {
                    void var5_19;
                    void var5_17;
                    var3_5 = binding.getInterfaces();
                    n = var3_5.length;
                    boolean bl = false;
                    while (var5_17 < n) {
                        ITypeBinding iTypeBinding = var3_5[var5_17];
                        resultEnum.getImplements().addAll(JDTBindingConverterUtility.convertToTypeReferences(iTypeBinding));
                        ++var5_17;
                    }
                    var3_5 = binding.getDeclaredFields();
                    n = var3_5.length;
                    boolean bl2 = false;
                    while (var5_19 < n) {
                        ITypeBinding iTypeBinding = var3_5[var5_19];
                        if (iTypeBinding.isEnumConstant()) {
                            resultEnum.getConstants().add((Object)JDTBindingConverterUtility.convertToEnumConstant((IVariableBinding)iTypeBinding));
                        }
                        ++var5_19;
                    }
                }
                catch (AbortCompilation abortCompilation) {
                    // empty catch block
                }
            }
            result = resultEnum;
        }
        if (binding.getPackage() != null) {
            result.setPackage(JDTBindingConverterUtility.convertToPackageProxy(binding.getPackage(), (EObject)result, ClassifiersPackage.Literals.CONCRETE_CLASSIFIER__PACKAGE));
        }
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getAnnotations()) {
                result.getAnnotationsAndModifiers().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(iAnnotationBinding));
            }
            for (IAnnotationBinding iAnnotationBinding : binding.getTypeParameters()) {
                result.getTypeParameters().add((Object)JDTBindingConverterUtility.convertToTypeParameter((ITypeBinding)iAnnotationBinding));
            }
        }
        catch (AbortCompilation resultEnum) {
            // empty catch block
        }
        result.getAnnotationsAndModifiers().addAll(JDTBindingConverterUtility.convertToModifiers(binding.getModifiers()));
        JDTBindingConverterUtility.convertToNameAndSet(binding, (NamedElement)result);
        try {
            void var5_28;
            void var5_26;
            Object member;
            void var5_24;
            IVariableBinding[] iVariableBindingArray = binding.getDeclaredFields();
            n = iVariableBindingArray.length;
            boolean bl = false;
            while (var5_24 < n) {
                IVariableBinding iVariableBinding = iVariableBindingArray[var5_24];
                if (!iVariableBinding.isEnumConstant()) {
                    member = JDTBindingConverterUtility.convertToField(iVariableBinding);
                    result.getMembers().add(member);
                }
                ++var5_24;
            }
            iVariableBindingArray = binding.getDeclaredMethods();
            n = iVariableBindingArray.length;
            boolean bl3 = false;
            while (var5_26 < n) {
                IVariableBinding iVariableBinding = iVariableBindingArray[var5_26];
                if (!iVariableBinding.isDefaultConstructor()) {
                    member = iVariableBinding.isConstructor() ? JDTBindingConverterUtility.convertToConstructor((IMethodBinding)iVariableBinding) : JDTBindingConverterUtility.convertToMethod((IMethodBinding)iVariableBinding);
                    result.getMembers().add(member);
                }
                ++var5_26;
            }
            iVariableBindingArray = binding.getDeclaredTypes();
            n = iVariableBindingArray.length;
            boolean bl4 = false;
            while (var5_28 < n) {
                IVariableBinding iVariableBinding = iVariableBindingArray[var5_28];
                member = JDTBindingConverterUtility.convertToConcreteClassifier((ITypeBinding)iVariableBinding);
                result.getMembers().add(member);
                ++var5_28;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        return result;
    }

    private static TypeParameter convertToTypeParameter(ITypeBinding binding) {
        TypeParameter result = GenericsFactory.eINSTANCE.createTypeParameter();
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getAnnotations()) {
                result.getAnnotations().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(iAnnotationBinding));
            }
            for (IAnnotationBinding iAnnotationBinding : binding.getTypeBounds()) {
                result.getExtendTypes().addAll(JDTBindingConverterUtility.convertToTypeReferences((ITypeBinding)iAnnotationBinding));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        JDTBindingConverterUtility.convertToNameAndSet(binding, (NamedElement)result);
        return result;
    }

    private static Reference internalConvertToReference(ITypeBinding binding) {
        IdentifierReference idRef = ReferencesFactory.eINSTANCE.createIdentifierReference();
        Field proxyField = MembersFactory.eINSTANCE.createField();
        JDTBindingConverterUtility.convertToNameAndSet(binding, (NamedElement)proxyField);
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(idRef, ReferencesPackage.Literals.ELEMENT_REFERENCE__TARGET, proxyField.getName(), (EObject)proxyField, -1, (IBinding)binding);
        idRef.setTarget((ReferenceableElement)proxyField);
        if (binding.isNested()) {
            Reference parentRef = JDTBindingConverterUtility.internalConvertToReference(binding.getDeclaringClass());
            parentRef.setNext((Reference)idRef);
        }
        return idRef;
    }

    private static Reference getTopReference(Reference ref) {
        Reference currentRef = ref;
        Reference parentRef = ref.getPrevious();
        while (parentRef != null) {
            currentRef = parentRef;
            parentRef = currentRef.getPrevious();
        }
        return currentRef;
    }

    private static Field convertToField(IVariableBinding binding) {
        Field result = MembersFactory.eINSTANCE.createField();
        result.getAnnotationsAndModifiers().addAll(JDTBindingConverterUtility.convertToModifiers(binding.getModifiers()));
        try {
            for (IAnnotationBinding annotBind : binding.getAnnotations()) {
                result.getAnnotationsAndModifiers().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(annotBind));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        result.setName(binding.getName());
        result.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(binding.getType()).get(0));
        JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding.getType(), (ArrayTypeable)result.getTypeReference(), false);
        if (binding.getConstantValue() != null) {
            result.setInitialValue((Expression)JDTBindingConverterUtility.convertToPrimaryExpression(binding.getConstantValue()));
        }
        return result;
    }

    private static EnumConstant convertToEnumConstant(IVariableBinding binding) {
        EnumConstant result = MembersFactory.eINSTANCE.createEnumConstant();
        try {
            for (IAnnotationBinding annotBind : binding.getAnnotations()) {
                result.getAnnotations().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(annotBind));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        result.setName(binding.getName());
        return result;
    }

    private static Constructor convertToConstructor(IMethodBinding binding) {
        Constructor result = MembersFactory.eINSTANCE.createConstructor();
        result.getAnnotationsAndModifiers().addAll(JDTBindingConverterUtility.convertToModifiers(binding.getModifiers()));
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getAnnotations()) {
                result.getAnnotationsAndModifiers().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(iAnnotationBinding));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        result.setName(binding.getName());
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getTypeParameters()) {
                result.getTypeParameters().add((Object)JDTBindingConverterUtility.convertToTypeParameter((ITypeBinding)iAnnotationBinding));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        if (binding.getDeclaredReceiverType() != null) {
            ReceiverParameter param = ParametersFactory.eINSTANCE.createReceiverParameter();
            param.setName("");
            param.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(binding.getDeclaredReceiverType()).get(0));
            param.setOuterTypeReference(param.getTypeReference());
            param.setThisReference(LiteralsFactory.eINSTANCE.createThis());
            result.getParameters().add((Object)param);
        }
        for (int index = 0; index < binding.getParameterTypes().length; ++index) {
            ITypeBinding typeBind = binding.getParameterTypes()[index];
            Object param = binding.isVarargs() && index == binding.getParameterTypes().length - 1 ? ParametersFactory.eINSTANCE.createVariableLengthParameter() : ParametersFactory.eINSTANCE.createOrdinaryParameter();
            param.setName("param" + index);
            param.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(typeBind).get(0));
            JDTBindingConverterUtility.convertToArrayDimensionsAndSet(typeBind, (ArrayTypeable)param.getTypeReference(), binding.isVarargs() && index == binding.getParameterTypes().length - 1);
            IAnnotationBinding[] iAnnotationBindingArray = binding.getParameterAnnotations(index);
            try {
                for (IAnnotationBinding annotBind : iAnnotationBindingArray) {
                    param.getAnnotationsAndModifiers().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(annotBind));
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            result.getParameters().add(param);
        }
        for (ITypeBinding iTypeBinding : binding.getExceptionTypes()) {
            result.getExceptions().add((Object)JDTBindingConverterUtility.convertToNamespaceClassifierReference(iTypeBinding));
        }
        Block statement = StatementsFactory.eINSTANCE.createBlock();
        statement.setName("");
        result.setBlock(statement);
        return result;
    }

    private static Method convertToMethod(IMethodBinding binding) {
        Object result = binding.getDeclaringClass().isInterface() ? MembersFactory.eINSTANCE.createInterfaceMethod() : MembersFactory.eINSTANCE.createClassMethod();
        result.getAnnotationsAndModifiers().addAll(JDTBindingConverterUtility.convertToModifiers(binding.getModifiers()));
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getAnnotations()) {
                result.getAnnotationsAndModifiers().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(iAnnotationBinding));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        result.setName(binding.getName());
        result.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(binding.getReturnType()).get(0));
        JDTBindingConverterUtility.convertToArrayDimensionsAndSet(binding.getReturnType(), (ArrayTypeable)result.getTypeReference(), false);
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getTypeParameters()) {
                result.getTypeParameters().add((Object)JDTBindingConverterUtility.convertToTypeParameter((ITypeBinding)iAnnotationBinding));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        if (binding.getDeclaredReceiverType() != null) {
            ReceiverParameter param = ParametersFactory.eINSTANCE.createReceiverParameter();
            param.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(binding.getDeclaredReceiverType()).get(0));
            param.setName("");
            param.setThisReference(LiteralsFactory.eINSTANCE.createThis());
            result.getParameters().add((Object)param);
        }
        for (int index = 0; index < binding.getParameterTypes().length; ++index) {
            ITypeBinding typeBind = binding.getParameterTypes()[index];
            Object param = binding.isVarargs() && index == binding.getParameterTypes().length - 1 ? ParametersFactory.eINSTANCE.createVariableLengthParameter() : ParametersFactory.eINSTANCE.createOrdinaryParameter();
            param.setName("param" + index);
            param.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences(typeBind).get(0));
            JDTBindingConverterUtility.convertToArrayDimensionsAndSet(typeBind, (ArrayTypeable)param.getTypeReference(), binding.isVarargs() && index == binding.getParameterTypes().length - 1);
            try {
                IAnnotationBinding[] iAnnotationBindingArray;
                for (IAnnotationBinding annotBind : iAnnotationBindingArray = binding.getParameterAnnotations(index)) {
                    param.getAnnotationsAndModifiers().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(annotBind));
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            result.getParameters().add(param);
        }
        if (binding.getDefaultValue() != null) {
            result.setDefaultValue(JDTBindingConverterUtility.convertToAnnotationValue(binding.getDefaultValue()));
        }
        try {
            for (ITypeBinding iTypeBinding : binding.getExceptionTypes()) {
                result.getExceptions().add((Object)JDTBindingConverterUtility.convertToNamespaceClassifierReference(iTypeBinding));
            }
        }
        catch (AbortCompilation index) {
            // empty catch block
        }
        if (binding.getDeclaringClass().isInterface()) {
            boolean hasDefaultImpl = false;
            for (tools.mdsd.jamopp.model.java.modifiers.Modifier mod : result.getModifiers()) {
                if (!(mod instanceof Default)) continue;
                hasDefaultImpl = true;
                break;
            }
            if (!hasDefaultImpl) {
                result.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
            }
        }
        if (result.getStatement() == null) {
            Block block = StatementsFactory.eINSTANCE.createBlock();
            block.setName("");
            result.setStatement((Statement)block);
        }
        return result;
    }

    private static NamespaceClassifierReference convertToNamespaceClassifierReference(ITypeBinding binding) {
        NamespaceClassifierReference ref = TypesFactory.eINSTANCE.createNamespaceClassifierReference();
        if (binding.getPackage() != null) {
            JDTBindingConverterUtility.convertIPackageNameComponentsToNamespaces(binding.getPackage(), (NamespaceAwareElement)ref);
        }
        ClassifierReference classRef = TypesFactory.eINSTANCE.createClassifierReference();
        Class proxyClass = ClassifiersFactory.eINSTANCE.createClass();
        JDTBindingConverterUtility.convertToNameAndSet(binding, (NamedElement)proxyClass);
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(classRef, TypesPackage.Literals.CLASSIFIER_REFERENCE__TARGET, proxyClass.getName(), (EObject)proxyClass, -1, (IBinding)binding);
        classRef.setTarget((Classifier)proxyClass);
        ref.getClassifierReferences().add((Object)classRef);
        return ref;
    }

    private static AnnotationInstance convertToAnnotationInstance(IAnnotationBinding binding) {
        AnnotationInstance result = AnnotationsFactory.eINSTANCE.createAnnotationInstance();
        Annotation resultClass = ClassifiersFactory.eINSTANCE.createAnnotation();
        JDTBindingConverterUtility.convertToNameAndSet(binding.getAnnotationType(), (NamedElement)resultClass);
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(result, AnnotationsPackage.Literals.ANNOTATION_INSTANCE__ANNOTATION, resultClass.getName(), (EObject)resultClass, -1, (IBinding)binding.getAnnotationType());
        result.setAnnotation((Classifier)resultClass);
        if (binding.getDeclaredMemberValuePairs().length > 0) {
            AnnotationParameterList params = AnnotationsFactory.eINSTANCE.createAnnotationParameterList();
            for (IMemberValuePairBinding memBind : binding.getDeclaredMemberValuePairs()) {
                params.getSettings().add((Object)JDTBindingConverterUtility.convertToAnnotationAttributeSetting(memBind));
            }
            result.setParameter((AnnotationParameter)params);
        }
        return result;
    }

    private static AnnotationAttributeSetting convertToAnnotationAttributeSetting(IMemberValuePairBinding binding) {
        AnnotationAttributeSetting result = AnnotationsFactory.eINSTANCE.createAnnotationAttributeSetting();
        InterfaceMethod proxyMeth = MembersFactory.eINSTANCE.createInterfaceMethod();
        proxyMeth.setName(binding.getMethodBinding().getName());
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(result, AnnotationsPackage.Literals.ANNOTATION_ATTRIBUTE_SETTING__ATTRIBUTE, proxyMeth.getName(), (EObject)proxyMeth, -1, (IBinding)binding.getMethodBinding());
        result.setAttribute(proxyMeth);
        result.setValue(JDTBindingConverterUtility.convertToAnnotationValue(binding.getValue()));
        return result;
    }

    private static AnnotationValue convertToAnnotationValue(Object value) {
        if (value instanceof IVariableBinding) {
            IVariableBinding varBind = (IVariableBinding)value;
            Reference parentRef = JDTBindingConverterUtility.internalConvertToReference(varBind.getDeclaringClass());
            IdentifierReference varRef = ReferencesFactory.eINSTANCE.createIdentifierReference();
            EnumConstant proxyConst = MembersFactory.eINSTANCE.createEnumConstant();
            proxyConst.setName(varBind.getName());
            IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(varRef, ReferencesPackage.Literals.ELEMENT_REFERENCE__TARGET, proxyConst.getName(), (EObject)proxyConst, -1, (IBinding)varBind);
            varRef.setTarget((ReferenceableElement)proxyConst);
            parentRef.setNext((Reference)varRef);
            return JDTBindingConverterUtility.getTopReference((Reference)varRef);
        }
        if (value instanceof IAnnotationBinding) {
            return JDTBindingConverterUtility.convertToAnnotationInstance((IAnnotationBinding)value);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            ArrayInitializer initializer = ArraysFactory.eINSTANCE.createArrayInitializer();
            for (int index = 0; index < values.length; ++index) {
                initializer.getInitialValues().add((Object)((ArrayInitializationValue)JDTBindingConverterUtility.convertToAnnotationValue(values[index])));
            }
            return initializer;
        }
        if (value instanceof ITypeBinding) {
            Reference parentRef = JDTBindingConverterUtility.internalConvertToReference((ITypeBinding)value);
            ReflectiveClassReference classRef = ReferencesFactory.eINSTANCE.createReflectiveClassReference();
            parentRef.setNext((Reference)classRef);
            return JDTBindingConverterUtility.getTopReference((Reference)classRef);
        }
        return JDTBindingConverterUtility.convertToPrimaryExpression(value);
    }

    private static PrimaryExpression convertToPrimaryExpression(Object value) {
        if (value instanceof String) {
            StringReference ref = ReferencesFactory.eINSTANCE.createStringReference();
            ref.setValue("");
            return ref;
        }
        if (value instanceof Boolean) {
            BooleanLiteral literal = LiteralsFactory.eINSTANCE.createBooleanLiteral();
            literal.setValue(((Boolean)value).booleanValue());
            return literal;
        }
        if (value instanceof Character) {
            CharacterLiteral literal = LiteralsFactory.eINSTANCE.createCharacterLiteral();
            literal.setValue("\\u" + Integer.toHexString(((Character)value).charValue()));
            return literal;
        }
        if (value instanceof Byte) {
            DecimalIntegerLiteral literal = LiteralsFactory.eINSTANCE.createDecimalIntegerLiteral();
            literal.setDecimalValue(BigInteger.valueOf(((Byte)value).byteValue()));
            return literal;
        }
        if (value instanceof Short) {
            DecimalIntegerLiteral literal = LiteralsFactory.eINSTANCE.createDecimalIntegerLiteral();
            literal.setDecimalValue(BigInteger.valueOf(((Short)value).shortValue()));
            return literal;
        }
        if (value instanceof Integer) {
            DecimalIntegerLiteral literal = LiteralsFactory.eINSTANCE.createDecimalIntegerLiteral();
            literal.setDecimalValue(BigInteger.valueOf(((Integer)value).intValue()));
            return literal;
        }
        if (value instanceof Long) {
            DecimalLongLiteral literal = LiteralsFactory.eINSTANCE.createDecimalLongLiteral();
            literal.setDecimalValue(BigInteger.valueOf((Long)value));
            return literal;
        }
        if (value instanceof Float) {
            DecimalFloatLiteral literal = LiteralsFactory.eINSTANCE.createDecimalFloatLiteral();
            literal.setDecimalValue(((Float)value).floatValue());
            return literal;
        }
        if (value instanceof Double) {
            DecimalDoubleLiteral literal = LiteralsFactory.eINSTANCE.createDecimalDoubleLiteral();
            literal.setDecimalValue(((Double)value).doubleValue());
            return literal;
        }
        NullLiteral literal = LiteralsFactory.eINSTANCE.createNullLiteral();
        return literal;
    }

    private static List<tools.mdsd.jamopp.model.java.modifiers.Modifier> convertToModifiers(int modifiers) {
        ArrayList<tools.mdsd.jamopp.model.java.modifiers.Modifier> result = new ArrayList<tools.mdsd.jamopp.model.java.modifiers.Modifier>();
        if (Modifier.isAbstract((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createAbstract());
        }
        if (Modifier.isDefault((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createDefault());
        }
        if (Modifier.isFinal((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createFinal());
        }
        if (Modifier.isNative((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createNative());
        }
        if (Modifier.isPrivate((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createPrivate());
        }
        if (Modifier.isProtected((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createProtected());
        }
        if (Modifier.isPublic((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createPublic());
        }
        if (Modifier.isStatic((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createStatic());
        }
        if (Modifier.isStrictfp((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createStrictfp());
        }
        if (Modifier.isSynchronized((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createSynchronized());
        }
        if (Modifier.isTransient((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createTransient());
        }
        if (Modifier.isVolatile((int)modifiers)) {
            result.add((tools.mdsd.jamopp.model.java.modifiers.Modifier)ModifiersFactory.eINSTANCE.createVolatile());
        }
        return result;
    }

    static Package convertToPackage(IPackageBinding binding) {
        Package pack = ContainersFactory.eINSTANCE.createPackage();
        pack.setOrigin(Origin.BINDING);
        JDTBindingConverterUtility.convertIPackageNameComponentsToNamespaces(binding, (NamespaceAwareElement)pack);
        pack.setName("");
        try {
            for (IAnnotationBinding annotBind : binding.getAnnotations()) {
                pack.getAnnotations().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(annotBind));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        if (binding.getModule() != null) {
            Module proxy = ContainersFactory.eINSTANCE.createModule();
            proxy.setName(binding.getModule().getName());
            IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(pack, ContainersPackage.Literals.PACKAGE__MODULE, proxy.getName(), (EObject)proxy, -1, (IBinding)binding.getModule());
            pack.setModule(proxy);
        }
        return pack;
    }

    private static void convertIPackageNameComponentsToNamespaces(IPackageBinding binding, NamespaceAwareElement element) {
        for (String com : binding.getNameComponents()) {
            element.getNamespaces().add((Object)com);
        }
    }

    private static Package convertToPackageProxy(IPackageBinding binding, EObject container, EReference feature) {
        Package proxy = ContainersFactory.eINSTANCE.createPackage();
        JDTBindingConverterUtility.convertIPackageNameComponentsToNamespaces(binding, (NamespaceAwareElement)proxy);
        proxy.setName("");
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(container, feature, binding.getName(), (EObject)proxy, -1, (IBinding)binding);
        return proxy;
    }

    static Module convertToModule(IModuleBinding binding) {
        Module result = ContainersFactory.eINSTANCE.createModule();
        result.setOrigin(Origin.BINDING);
        try {
            for (IAnnotationBinding iAnnotationBinding : binding.getAnnotations()) {
                result.getAnnotations().add((Object)JDTBindingConverterUtility.convertToAnnotationInstance(iAnnotationBinding));
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        if (binding.isOpen()) {
            result.setOpen(ModifiersFactory.eINSTANCE.createOpen());
        }
        JDTBindingConverterUtility.convertToNamespacesAndSet(binding.getName(), (NamespaceAwareElement)result);
        result.setName("");
        try {
            ModuleReference ref;
            String modName;
            int n;
            int n2;
            String[] stringArray;
            String[] mods;
            ExportsModuleDirective dir;
            for (IAnnotationBinding iAnnotationBinding : binding.getExportedPackages()) {
                dir = ModulesFactory.eINSTANCE.createExportsModuleDirective();
                JDTBindingConverterUtility.convertIPackageNameComponentsToNamespaces((IPackageBinding)iAnnotationBinding, (NamespaceAwareElement)dir);
                dir.setAccessablePackage(JDTBindingConverterUtility.convertToPackageProxy((IPackageBinding)iAnnotationBinding, (EObject)dir, ModulesPackage.Literals.ACCESS_PROVIDING_MODULE_DIRECTIVE__ACCESSABLE_PACKAGE));
                stringArray = mods = binding.getExportedTo((IPackageBinding)iAnnotationBinding);
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    modName = stringArray[n];
                    ref = ModulesFactory.eINSTANCE.createModuleReference();
                    JDTBindingConverterUtility.convertToNamespacesAndSet(modName, (NamespaceAwareElement)ref);
                    dir.getModules().add((Object)ref);
                }
                result.getTarget().add((Object)dir);
            }
            for (IAnnotationBinding iAnnotationBinding : binding.getOpenedPackages()) {
                dir = ModulesFactory.eINSTANCE.createOpensModuleDirective();
                JDTBindingConverterUtility.convertIPackageNameComponentsToNamespaces((IPackageBinding)iAnnotationBinding, (NamespaceAwareElement)dir);
                dir.setAccessablePackage(JDTBindingConverterUtility.convertToPackageProxy((IPackageBinding)iAnnotationBinding, (EObject)dir, ModulesPackage.Literals.ACCESS_PROVIDING_MODULE_DIRECTIVE__ACCESSABLE_PACKAGE));
                stringArray = mods = binding.getOpenedTo((IPackageBinding)iAnnotationBinding);
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    modName = stringArray[n];
                    ref = ModulesFactory.eINSTANCE.createModuleReference();
                    JDTBindingConverterUtility.convertToNamespacesAndSet(modName, (NamespaceAwareElement)ref);
                    dir.getModules().add((Object)ref);
                }
                result.getTarget().add((Object)dir);
            }
            for (IAnnotationBinding iAnnotationBinding : binding.getRequiredModules()) {
                dir = ModulesFactory.eINSTANCE.createRequiresModuleDirective();
                dir.setRequiredModule(JDTBindingConverterUtility.convertToModuleReference((IModuleBinding)iAnnotationBinding));
                result.getTarget().add((Object)dir);
            }
            for (IAnnotationBinding iAnnotationBinding : binding.getUses()) {
                dir = ModulesFactory.eINSTANCE.createUsesModuleDirective();
                dir.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences((ITypeBinding)iAnnotationBinding).get(0));
                result.getTarget().add((Object)dir);
            }
            for (IAnnotationBinding iAnnotationBinding : binding.getServices()) {
                dir = ModulesFactory.eINSTANCE.createProvidesModuleDirective();
                dir.setTypeReference(JDTBindingConverterUtility.convertToTypeReferences((ITypeBinding)iAnnotationBinding).get(0));
                for (ITypeBinding service : binding.getImplementations((ITypeBinding)iAnnotationBinding)) {
                    dir.getServiceProviders().addAll(JDTBindingConverterUtility.convertToTypeReferences(service));
                }
                result.getTarget().add((Object)dir);
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        return result;
    }

    private static void convertToNamespacesAndSet(String namespaces, NamespaceAwareElement ele) {
        String[] singleNamespaces;
        for (String part : singleNamespaces = namespaces.split("\\.")) {
            ele.getNamespaces().add((Object)part);
        }
    }

    private static ModuleReference convertToModuleReference(IModuleBinding binding) {
        ModuleReference ref = ModulesFactory.eINSTANCE.createModuleReference();
        JDTBindingConverterUtility.convertToNamespacesAndSet(binding.getName(), (NamespaceAwareElement)ref);
        Module proxyMod = ContainersFactory.eINSTANCE.createModule();
        proxyMod.setName(binding.getName());
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.registerContextDependentURIFragment(ref, ModulesPackage.Literals.MODULE_REFERENCE__TARGET, proxyMod.getName(), (EObject)proxyMod, -1, (IBinding)binding);
        ref.setTarget(proxyMod);
        return ref;
    }
}

