/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.bindings;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.options.ParserOptions;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragmentCollector;
import tools.mdsd.jamopp.resolution.bindings.AbstractBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.CentralBindingBasedResolver;
import tools.mdsd.jamopp.resolution.bindings.JDTBindingConverterUtility;

class ITypeBindingResolver
extends AbstractBindingResolver<ITypeBinding> {
    private Pattern parentNamePattern = Pattern.compile("([a-zA-Z0-9\\.]++)((\\$[0-9]*+([a-zA-z][a-zA-z0-9]*+)?+)++)");
    private Pattern innerNamesPattern = Pattern.compile("\\$((([0-9]++)([a-zA-Z][a-zA-Z0-9]*+))|([0-9]++)|([a-zA-Z][a-zA-Z0-9]*+))");

    protected ITypeBindingResolver(CentralBindingBasedResolver parentResolver) {
        super(parentResolver);
    }

    @Override
    protected EObject resolve(ITypeBinding binding) {
        if ((binding = binding.getTypeDeclaration()).isAnonymous() || binding.isLocal()) {
            return this.findLocalOrAnonymousClass(binding.getBinaryName());
        }
        if (binding.isArray()) {
            return this.getParentResolver().resolve((IBinding)binding.getElementType());
        }
        if (binding.isTypeVariable()) {
            TypeParametrizable param = null;
            if (binding.getDeclaringClass() != null) {
                param = (TypeParametrizable)this.getParentResolver().resolve((IBinding)binding.getDeclaringClass());
            }
            if (param == null || param.getTypeParameters() == null) {
                return null;
            }
            for (TypeParameter p : param.getTypeParameters()) {
                if (!p.getName().equals(binding.getName())) continue;
                return p;
            }
        } else if (binding.isMember()) {
            EObject parent = this.getParentResolver().resolve((IBinding)binding.getDeclaringClass());
            if (parent != null && !parent.eIsProxy() && parent instanceof MemberContainer) {
                MemberContainer con = (MemberContainer)parent;
                for (Member member : con.getMembers()) {
                    if (!(member instanceof ConcreteClassifier) || !((ConcreteClassifier)member).getName().equals(binding.getName())) continue;
                    return member;
                }
            }
        } else if (binding.isTopLevel()) {
            URI baseURI = LogicalJavaURIGenerator.getClassifierURI((String)binding.getQualifiedName()).trimFragment();
            Resource potRes = this.getParentResolver().getResourceSet().getResource(baseURI, false);
            if (potRes == null && ParserOptions.PREFER_BINDING_CONVERSION.isTrue()) {
                return this.convertBinding(binding, baseURI);
            }
            ConcreteClassifier classifier = JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).getConcreteClassifier(binding.getQualifiedName());
            if ((classifier = (ConcreteClassifier)EcoreUtil.resolve((EObject)classifier, (ResourceSet)this.getParentResolver().getResourceSet())) == null || classifier.eIsProxy()) {
                classifier = this.convertBinding(binding, baseURI);
            }
            return classifier;
        }
        return null;
    }

    private ConcreteClassifier convertBinding(ITypeBinding binding, URI baseURI) {
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.setBaseURI(baseURI);
        CompilationUnit cu = JDTBindingConverterUtility.convertToCompilationUnit(binding);
        Resource potRes = this.getParentResolver().getResourceSet().createResource(baseURI);
        potRes.getContents().add((Object)cu);
        baseURI = (URI)JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).getURIMap().get(baseURI);
        JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).registerJavaRoot((JavaRoot)cu, baseURI);
        return (ConcreteClassifier)cu.getClassifiers().get(0);
    }

    private EObject findLocalOrAnonymousClass(String binaryName) {
        if (binaryName == null) {
            return null;
        }
        Matcher m1 = this.parentNamePattern.matcher(binaryName);
        if (m1.matches()) {
            String parentName = m1.group(1);
            ConcreteClassifier parentClassifier = JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).getConcreteClassifier(parentName);
            if (parentClassifier != null) {
                parentClassifier = (ConcreteClassifier)EcoreUtil.resolve((EObject)parentClassifier, (ResourceSet)this.getParentResolver().getResourceSet());
            }
            if (parentClassifier != null && !parentClassifier.eIsProxy()) {
                Matcher m2 = this.innerNamesPattern.matcher(m1.group(2));
                ConcreteClassifier currentContainer = parentClassifier;
                block0: while (m2.find()) {
                    String index = m2.group(3);
                    index = index == null ? m2.group(5) : index;
                    String innerClass = m2.group(4);
                    String string = innerClass = innerClass == null ? m2.group(6) : innerClass;
                    if (index == null && innerClass != null) {
                        for (Member mem : currentContainer.getMembers()) {
                            if (!(mem instanceof ConcreteClassifier) || !((ConcreteClassifier)mem).getName().equals(innerClass)) continue;
                            currentContainer = (ConcreteClassifier)mem;
                            continue block0;
                        }
                        continue;
                    }
                    if (index != null && innerClass != null) {
                        int i = Integer.parseInt(index);
                        int currentIndex = 1;
                        for (ConcreteClassifier conClass : currentContainer.getChildrenByType(ConcreteClassifier.class)) {
                            if (conClass.eContainer() instanceof MemberContainer) continue;
                            AnonymousClass conContainer = ((Commentable)conClass.eContainer()).getContainingAnonymousClass();
                            if (conContainer != null && conContainer.equals(currentContainer)) {
                                if (currentIndex == i) {
                                    currentContainer = conClass;
                                    continue block0;
                                }
                                ++currentIndex;
                                continue;
                            }
                            conContainer = ((Commentable)conClass.eContainer()).getContainingConcreteClassifier();
                            if (!currentContainer.equals(conContainer)) continue;
                            if (currentIndex == i) {
                                currentContainer = conClass;
                                continue block0;
                            }
                            ++currentIndex;
                        }
                        continue;
                    }
                    if (index == null || innerClass != null) continue;
                    int i = Integer.parseInt(index);
                    int currentIndex = 1;
                    for (AnonymousClass ano : currentContainer.getChildrenByType(AnonymousClass.class)) {
                        AnonymousClass anoContainer = ((Commentable)ano.eContainer()).getContainingAnonymousClass();
                        if (anoContainer != null && anoContainer.equals(currentContainer)) {
                            if (currentIndex == i) {
                                currentContainer = ano;
                                continue block0;
                            }
                            ++currentIndex;
                            continue;
                        }
                        anoContainer = ((Commentable)ano.eContainer()).getContainingConcreteClassifier();
                        if (!currentContainer.equals(anoContainer)) continue;
                        if (currentIndex == i) {
                            currentContainer = ano;
                            continue block0;
                        }
                        ++currentIndex;
                    }
                }
                return currentContainer;
            }
        }
        return null;
    }
}

