/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.bindings;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.IPackageBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.options.ParserOptions;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragmentCollector;
import tools.mdsd.jamopp.resolution.bindings.AbstractBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.CentralBindingBasedResolver;
import tools.mdsd.jamopp.resolution.bindings.JDTBindingConverterUtility;

class IPackageBindingResolver
extends AbstractBindingResolver<IPackageBinding> {
    protected IPackageBindingResolver(CentralBindingBasedResolver parentResolver) {
        super(parentResolver);
    }

    @Override
    protected EObject resolve(IPackageBinding binding) {
        URI uri = LogicalJavaURIGenerator.getPackageURI((String)binding.getName());
        Resource packContainer = this.getParentResolver().findPackageResourceInResourceSet(binding.getName());
        if (packContainer == null) {
            packContainer = this.getParentResolver().findResourceInResourceSet(uri);
        }
        if (packContainer == null) {
            if (ParserOptions.PREFER_BINDING_CONVERSION.isTrue()) {
                return this.convertBindingToPackage(binding, uri);
            }
            try {
                packContainer = this.getParentResolver().getResourceSet().getResource(uri, true);
                if (packContainer != null) {
                    return (Package)packContainer.getContents().get(0);
                }
            }
            catch (RuntimeException runtimeException) {}
        } else if (!packContainer.getContents().isEmpty()) {
            return (Package)packContainer.getContents().get(0);
        }
        return this.convertBindingToPackage(binding, uri);
    }

    private Package convertBindingToPackage(IPackageBinding binding, URI uri) {
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.setBaseURI(uri);
        Package result = JDTBindingConverterUtility.convertToPackage(binding);
        Resource packContainer = this.getParentResolver().getResourceSet().createResource(uri);
        packContainer.getContents().add((Object)result);
        uri = (URI)JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).getURIMap().get(uri);
        JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).registerJavaRoot((JavaRoot)result, uri);
        return result;
    }
}

