/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.bindings;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.IModuleBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.options.ParserOptions;
import tools.mdsd.jamopp.proxy.IJavaContextDependentURIFragmentCollector;
import tools.mdsd.jamopp.resolution.bindings.AbstractBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.CentralBindingBasedResolver;
import tools.mdsd.jamopp.resolution.bindings.JDTBindingConverterUtility;

class IModuleBindingResolver
extends AbstractBindingResolver<IModuleBinding> {
    protected IModuleBindingResolver(CentralBindingBasedResolver parentResolver) {
        super(parentResolver);
    }

    @Override
    protected EObject resolve(IModuleBinding binding) {
        URI uri = LogicalJavaURIGenerator.getModuleURI((String)binding.getName());
        Resource modContainer = this.getParentResolver().findModuleResourceInResourceSet(binding.getName());
        if (modContainer == null) {
            modContainer = this.getParentResolver().findResourceInResourceSet(uri);
        }
        if (modContainer == null) {
            if (ParserOptions.PREFER_BINDING_CONVERSION.isTrue()) {
                return this.convertBindingToModule(binding, uri);
            }
            try {
                modContainer = this.getParentResolver().getResourceSet().getResource(uri, true);
                if (modContainer != null) {
                    return (Module)modContainer.getContents().get(0);
                }
            }
            catch (RuntimeException runtimeException) {}
        } else {
            return (Module)modContainer.getContents().get(0);
        }
        return this.convertBindingToModule(binding, uri);
    }

    private Module convertBindingToModule(IModuleBinding binding, URI uri) {
        IJavaContextDependentURIFragmentCollector.GLOBAL_INSTANCE.setBaseURI(uri);
        Module result = JDTBindingConverterUtility.convertToModule(binding);
        Resource modContainer = this.getParentResolver().getResourceSet().createResource(uri);
        modContainer.getContents().add((Object)result);
        uri = (URI)JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).getURIMap().get(uri);
        JavaClasspath.get((ResourceSet)this.getParentResolver().getResourceSet()).registerJavaRoot((JavaRoot)result, uri);
        return result;
    }
}

