/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.bindings;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.types.Boolean;
import tools.mdsd.jamopp.model.java.types.Byte;
import tools.mdsd.jamopp.model.java.types.Char;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.Double;
import tools.mdsd.jamopp.model.java.types.Float;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.Int;
import tools.mdsd.jamopp.model.java.types.Long;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.Short;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.resolution.bindings.AbstractBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.CentralBindingBasedResolver;

class IMethodBindingResolver
extends AbstractBindingResolver<IMethodBinding> {
    protected IMethodBindingResolver(CentralBindingBasedResolver parentResolver) {
        super(parentResolver);
    }

    @Override
    protected EObject resolve(IMethodBinding binding) {
        binding = binding.getMethodDeclaration();
        EObject container = this.getParentResolver().resolve((IBinding)binding.getDeclaringClass());
        if (container instanceof MemberContainer) {
            for (Member mem : ((MemberContainer)container).getMembers()) {
                if (binding.isConstructor() && mem instanceof Constructor && this.checkConstructor(binding, (Constructor)mem)) {
                    return mem;
                }
                if (!(mem instanceof Method) || !this.checkMethod((Method)mem, binding)) continue;
                return mem;
            }
        }
        return null;
    }

    private boolean checkMethod(Method meth, IMethodBinding binding) {
        if (meth.getName().equals(binding.getName())) {
            if (meth.getName().equals("clone")) {
                return true;
            }
            int receiveOffset = 0;
            if (binding.getDeclaredReceiverType() != null) {
                receiveOffset = 1;
            }
            if (binding.getParameterTypes().length + receiveOffset == meth.getParameters().size()) {
                if (!(receiveOffset != 1 || meth.getParameters().get(0) instanceof ReceiverParameter && IMethodBindingResolver.convertToTypeName(binding.getDeclaredReceiverType()).equals(this.convertToTypeName(((Parameter)meth.getParameters().get(0)).getTypeReference())))) {
                    return false;
                }
                if (!IMethodBindingResolver.convertToTypeName(binding.getReturnType()).equals(this.convertToTypeName(meth.getTypeReference()))) {
                    return false;
                }
                for (int i = 0; i < binding.getParameterTypes().length; ++i) {
                    ITypeBinding currentParamType = binding.getParameterTypes()[i];
                    Parameter currentParam = (Parameter)meth.getParameters().get(i + receiveOffset);
                    if (IMethodBindingResolver.convertToTypeName(currentParamType).equals(this.convertToTypeName(currentParam.getTypeReference())) && (long)currentParamType.getDimensions() == currentParam.getTypeReference().getArrayDimension()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static String convertToTypeName(ITypeBinding binding) {
        Object qualifiedName;
        if (binding == null) {
            return "";
        }
        if (binding.isTypeVariable()) {
            return binding.getName();
        }
        if (binding.isMember()) {
            qualifiedName = IMethodBindingResolver.convertToTypeName(binding.getDeclaringClass()) + "." + binding.getName();
        } else {
            if (binding.isLocal()) {
                return binding.getName();
            }
            if (binding.isArray()) {
                return IMethodBindingResolver.convertToTypeName(binding.getElementType());
            }
            qualifiedName = binding.getQualifiedName();
        }
        if (((String)qualifiedName).contains("<")) {
            qualifiedName = ((String)qualifiedName).substring(0, ((String)qualifiedName).indexOf("<"));
        }
        return qualifiedName;
    }

    private String convertToTypeName(TypeReference ref) {
        if (ref instanceof ClassifierReference) {
            ClassifierReference convRef = (ClassifierReference)ref;
            Classifier target = convRef.getTarget();
            if (target.eIsProxy()) {
                target = (Classifier)EcoreUtil.resolve((EObject)target, (ResourceSet)this.getParentResolver().getResourceSet());
            }
            if (target instanceof ConcreteClassifier) {
                return ((ConcreteClassifier)target).getQualifiedName();
            }
            if (target instanceof InferableType) {
                return "var";
            }
            return ((TypeParameter)target).getName();
        }
        if (ref instanceof NamespaceClassifierReference) {
            NamespaceClassifierReference nRef = (NamespaceClassifierReference)ref;
            if (nRef.getClassifierReferences().size() > 0) {
                return this.convertToTypeName((TypeReference)nRef.getClassifierReferences().get(nRef.getClassifierReferences().size() - 1));
            }
            return LogicalJavaURIGenerator.packageName((NamespaceAwareElement)nRef);
        }
        if (ref instanceof Boolean) {
            return "boolean";
        }
        if (ref instanceof Byte) {
            return "byte";
        }
        if (ref instanceof Char) {
            return "char";
        }
        if (ref instanceof Double) {
            return "double";
        }
        if (ref instanceof Float) {
            return "float";
        }
        if (ref instanceof Int) {
            return "int";
        }
        if (ref instanceof Long) {
            return "long";
        }
        if (ref instanceof Short) {
            return "short";
        }
        return "void";
    }

    private boolean checkConstructor(IMethodBinding binding, Constructor c) {
        if (c.getName().equals(binding.getName())) {
            int receiveOffset = 0;
            if (binding.getDeclaredReceiverType() != null) {
                receiveOffset = 1;
            }
            if (c.getParameters().size() == binding.getParameterTypes().length + receiveOffset) {
                if (!(receiveOffset != 1 || c.getParameters().get(0) instanceof ReceiverParameter && IMethodBindingResolver.convertToTypeName(binding.getDeclaredReceiverType()).equals(this.convertToTypeName(((Parameter)c.getParameters().get(0)).getTypeReference())))) {
                    return false;
                }
                for (int i = 0; i < binding.getParameterTypes().length; ++i) {
                    ITypeBinding currentType = binding.getParameterTypes()[i];
                    Parameter currentParam = (Parameter)c.getParameters().get(i + receiveOffset);
                    if (IMethodBindingResolver.convertToTypeName(currentType).equals(this.convertToTypeName(currentParam.getTypeReference())) && (long)currentType.getDimensions() == currentParam.getTypeReference().getArrayDimension()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

