/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.resolution.bindings;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.resolution.bindings.IAnnotationBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.IMemberValuePairBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.IMethodBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.IModuleBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.IPackageBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.ITypeBindingResolver;
import tools.mdsd.jamopp.resolution.bindings.IVariableBindingResolver;

public class CentralBindingBasedResolver {
    private ITypeBindingResolver typeResolver = new ITypeBindingResolver(this);
    private IModuleBindingResolver moduleResolver = new IModuleBindingResolver(this);
    private IPackageBindingResolver packageResolver = new IPackageBindingResolver(this);
    private IAnnotationBindingResolver annotationResolver = new IAnnotationBindingResolver(this);
    private IMemberValuePairBindingResolver memberValueResolver = new IMemberValuePairBindingResolver(this);
    private IMethodBindingResolver methodResolver = new IMethodBindingResolver(this);
    private IVariableBindingResolver variableResolver = new IVariableBindingResolver(this);
    private ResourceSet resSet;

    public CentralBindingBasedResolver() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public CentralBindingBasedResolver(ResourceSet set) {
        this.resSet = set;
    }

    public EObject resolve(IBinding binding) {
        if (binding == null || binding.isRecovered()) {
            return null;
        }
        EObject res = null;
        if (binding.getKind() == 2) {
            res = this.typeResolver.resolve((ITypeBinding)binding);
        } else if (binding.getKind() == 7) {
            res = this.moduleResolver.resolve((IModuleBinding)binding);
        } else if (binding.getKind() == 1) {
            res = this.packageResolver.resolve((IPackageBinding)binding);
        } else if (binding.getKind() == 5) {
            res = this.annotationResolver.resolve((IAnnotationBinding)binding);
        } else if (binding.getKind() == 6) {
            res = this.memberValueResolver.resolve((IMemberValuePairBinding)binding);
        } else if (binding.getKind() == 4) {
            res = this.methodResolver.resolve((IMethodBinding)binding);
        } else if (binding.getKind() == 3) {
            res = this.variableResolver.resolve((IVariableBinding)binding);
        }
        return res;
    }

    ResourceSet getResourceSet() {
        return this.resSet;
    }

    Resource findResourceInResourceSet(URI uri) {
        for (Resource res : this.resSet.getResources()) {
            if (!res.getURI().equals(uri)) continue;
            return res;
        }
        return null;
    }

    Resource findPackageResourceInResourceSet(String packageName) {
        for (Resource res : this.resSet.getResources()) {
            Package pack;
            String packName;
            if (res.getContents().size() <= 0 || !(res.getContents().get(0) instanceof Package) || !(packName = (packName = (pack = (Package)res.getContents().get(0)).getNamespacesAsString()).length() != 0 ? packName.substring(0, packName.length() - 1) : packName).equals(packageName)) continue;
            return res;
        }
        return null;
    }

    Resource findModuleResourceInResourceSet(String moduleName) {
        for (Resource res : this.resSet.getResources()) {
            Module mod;
            String modName;
            if (res.getContents().size() <= 0 || !(res.getContents().get(0) instanceof Module) || !(modName = (modName = (mod = (Module)res.getContents().get(0)).getNamespacesAsString()).length() != 0 ? modName.substring(0, modName.length() - 1) : modName).equals(moduleName)) continue;
            return res;
        }
        return null;
    }
}

