/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.recovery.trivial;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;

public class TrivialRecovery {
    private ResourceSet set;
    private Resource artificialResource;
    private CompilationUnit artificialCU;
    private Class artificialClass;
    private Class objectClass;
    private HashMap<String, Class> artClasses = new HashMap();
    private HashMap<String, Annotation> artAnnotations = new HashMap();
    private HashMap<String, Field> artFields = new HashMap();
    private HashMap<String, ClassMethod> artClassMethods = new HashMap();
    private HashMap<String, InterfaceMethod> artInterfaceMethods = new HashMap();
    private HashMap<String, Package> artPackages = new HashMap();
    private HashMap<String, Module> artModules = new HashMap();

    public TrivialRecovery(ResourceSet set) {
        this.set = set;
    }

    public void recover() {
        Map proxies = EcoreUtil.ProxyCrossReferencer.find((ResourceSet)this.set);
        for (Map.Entry entry : proxies.entrySet()) {
            EObject proxy = (EObject)entry.getKey();
            EObject actualElement = this.recoverActualElement(proxy);
            for (EStructuralFeature.Setting setting : (Collection)entry.getValue()) {
                if (setting.getEStructuralFeature().isMany()) {
                    EList list = (EList)setting.getEObject().eGet(setting.getEStructuralFeature());
                    int idx = list.indexOf((Object)proxy);
                    list.set(idx, (Object)actualElement);
                    continue;
                }
                setting.getEObject().eSet(setting.getEStructuralFeature(), (Object)actualElement);
            }
        }
        this.set.getResources().forEach(resource -> resource.getErrors().clear());
    }

    private EObject recoverActualElement(EObject obj) {
        this.initArtificialResource();
        String name = ((NamedElement)obj).getName();
        if (obj instanceof Class) {
            if (this.artClasses.containsKey(name)) {
                return (EObject)this.artClasses.get(name);
            }
            Class result = ClassifiersFactory.eINSTANCE.createClass();
            result.setName(name);
            this.artificialCU.getClassifiers().add((Object)result);
            this.artClasses.put(name, result);
            return result;
        }
        if (obj instanceof Annotation) {
            if (this.artAnnotations.containsKey(name)) {
                return (EObject)this.artAnnotations.get(name);
            }
            Annotation result = ClassifiersFactory.eINSTANCE.createAnnotation();
            result.setName(name);
            this.artificialCU.getClassifiers().add((Object)result);
            this.artAnnotations.put(name, result);
            return result;
        }
        if (obj instanceof Field) {
            if (this.artFields.containsKey(name)) {
                return (EObject)this.artFields.get(name);
            }
            Field result = MembersFactory.eINSTANCE.createField();
            ClassifierReference reference = TypesFactory.eINSTANCE.createClassifierReference();
            reference.setTarget((Classifier)this.objectClass);
            result.setTypeReference((TypeReference)reference);
            result.setName(name);
            this.artificialClass.getMembers().add((Object)result);
            this.artFields.put(name, result);
            return result;
        }
        if (obj instanceof ClassMethod) {
            if (this.artClassMethods.containsKey(name)) {
                return (EObject)this.artClassMethods.get(name);
            }
            ClassMethod result = MembersFactory.eINSTANCE.createClassMethod();
            result.setName(name);
            Block statement = StatementsFactory.eINSTANCE.createBlock();
            statement.setName("");
            result.setStatement((Statement)statement);
            result.setTypeReference((TypeReference)TypesFactory.eINSTANCE.createVoid());
            this.artificialClass.getMembers().add((Object)result);
            this.artClassMethods.put(name, result);
            return result;
        }
        if (obj instanceof InterfaceMethod) {
            if (this.artInterfaceMethods.containsKey(name)) {
                return (EObject)this.artInterfaceMethods.get(name);
            }
            InterfaceMethod result = MembersFactory.eINSTANCE.createInterfaceMethod();
            result.setName(name);
            result.setStatement((Statement)StatementsFactory.eINSTANCE.createEmptyStatement());
            result.setTypeReference((TypeReference)TypesFactory.eINSTANCE.createVoid());
            this.artificialClass.getMembers().add((Object)result);
            this.artInterfaceMethods.put(name, result);
            return result;
        }
        if (obj instanceof Package) {
            Package p = (Package)obj;
            name = p.getNamespacesAsString();
            if (this.artPackages.containsKey(name)) {
                return (EObject)this.artPackages.get(name);
            }
            Package result = ContainersFactory.eINSTANCE.createPackage();
            p.getNamespaces().forEach(ns -> result.getNamespaces().add(ns));
            this.artificialResource.getContents().add((Object)result);
            this.artPackages.put(name, result);
            return result;
        }
        if (obj instanceof Module) {
            if (this.artModules.containsKey(name)) {
                return (EObject)this.artModules.get(name);
            }
            Module result = ContainersFactory.eINSTANCE.createModule();
            result.setName(name);
            this.artificialResource.getContents().add((Object)result);
            this.artModules.put(name, result);
            return result;
        }
        return null;
    }

    private void initArtificialResource() {
        if (this.artificialResource == null) {
            this.artificialResource = this.set.createResource(URI.createURI((String)"pathmap:/javaclass/ArtificialResource.java"));
            this.artificialCU = ContainersFactory.eINSTANCE.createCompilationUnit();
            this.artificialResource.getContents().add((Object)this.artificialCU);
            this.artificialClass = ClassifiersFactory.eINSTANCE.createClass();
            this.artificialClass.setName("SyntheticClass");
            this.artificialCU.getClassifiers().add((Object)this.artificialClass);
            this.objectClass = this.findObjectClass();
            this.artClasses.put("Object", this.objectClass);
        }
    }

    private Class findObjectClass() {
        return this.set.getResources().stream().filter(resource -> !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof CompilationUnit).map(resource -> (CompilationUnit)resource.getContents().get(0)).filter(cu -> cu.getNamespaces().size() == 2 && ((String)cu.getNamespaces().get(0)).equals("java") && ((String)cu.getNamespaces().get(1)).equals("lang") && cu.getName().equals("Object")).map(cu -> (Class)cu.getClassifiers().get(0)).findFirst().get();
    }
}

