/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.statements.Assert;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Break;
import tools.mdsd.jamopp.model.java.statements.CatchBlock;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.Continue;
import tools.mdsd.jamopp.model.java.statements.DefaultSwitchCase;
import tools.mdsd.jamopp.model.java.statements.DefaultSwitchRule;
import tools.mdsd.jamopp.model.java.statements.DoWhileLoop;
import tools.mdsd.jamopp.model.java.statements.EmptyStatement;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.ForEachLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoop;
import tools.mdsd.jamopp.model.java.statements.JumpLabel;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.NormalSwitchCase;
import tools.mdsd.jamopp.model.java.statements.NormalSwitchRule;
import tools.mdsd.jamopp.model.java.statements.Return;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SwitchCase;
import tools.mdsd.jamopp.model.java.statements.SynchronizedBlock;
import tools.mdsd.jamopp.model.java.statements.Throw;
import tools.mdsd.jamopp.model.java.statements.TryBlock;
import tools.mdsd.jamopp.model.java.statements.WhileLoop;
import tools.mdsd.jamopp.model.java.statements.YieldStatement;
import tools.mdsd.jamopp.model.java.statements.util.StatementsSwitch;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

public class StatementsPrinterSwitch
extends StatementsSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    StatementsPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseAssert(Assert element) {
        try {
            this.writer.append("assert ");
            this.parent.doSwitch((EObject)element.getCondition());
            if (element.getErrorMessage() != null) {
                this.writer.append(" : ");
                this.parent.doSwitch((EObject)element.getErrorMessage());
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseBreak(Break element) {
        try {
            this.writer.append("break");
            if (element.getTarget() != null) {
                this.writer.append(" " + element.getTarget().getName());
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseCatchBlock(CatchBlock element) {
        try {
            this.writer.append("catch(");
            this.parent.doSwitch((EObject)element.getParameter());
            this.writer.append(")");
            this.parent.doSwitch((EObject)element.getBlock());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseContinue(Continue element) {
        try {
            this.writer.append("continue");
            if (element.getTarget() != null) {
                this.writer.append(" " + element.getTarget().getName());
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDoWhileLoop(DoWhileLoop element) {
        try {
            this.writer.append("do\n");
            this.parent.doSwitch((EObject)element.getStatement());
            this.writer.append("while (");
            this.parent.doSwitch((EObject)element.getCondition());
            this.writer.append(");\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseEmptyStatement(EmptyStatement element) {
        try {
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseCondition(Condition element) {
        try {
            this.writer.append("if (");
            this.parent.doSwitch((EObject)element.getCondition());
            this.writer.append(")\n");
            this.parent.doSwitch((EObject)element.getStatement());
            if (element.getElseStatement() != null) {
                this.writer.append("else\n");
                this.parent.doSwitch((EObject)element.getElseStatement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseExpressionStatement(ExpressionStatement element) {
        try {
            this.parent.doSwitch((EObject)element.getExpression());
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseForLoop(ForLoop element) {
        try {
            this.writer.append("for (");
            if (element.getInit() != null) {
                this.parent.doSwitch((EObject)element.getInit());
            }
            this.writer.append(" ; ");
            if (element.getCondition() != null) {
                this.parent.doSwitch((EObject)element.getCondition());
            }
            this.writer.append(" ; ");
            for (int index = 0; index < element.getUpdates().size(); ++index) {
                this.parent.doSwitch((EObject)element.getUpdates().get(index));
                if (index >= element.getUpdates().size() - 1) continue;
                this.writer.append(", ");
            }
            this.writer.append(")\n");
            this.parent.doSwitch((EObject)element.getStatement());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseForEachLoop(ForEachLoop element) {
        try {
            this.writer.append("for (");
            this.parent.doSwitch((EObject)element.getNext());
            this.writer.append(" : ");
            this.parent.doSwitch((EObject)element.getCollection());
            this.writer.append(")\n");
            this.parent.doSwitch((EObject)element.getStatement());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseJumpLabel(JumpLabel element) {
        try {
            this.writer.append(element.getName() + ": ");
            this.parent.doSwitch((EObject)element.getStatement());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseLocalVariableStatement(LocalVariableStatement element) {
        try {
            this.parent.doSwitch((EObject)element.getVariable());
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseBlock(Block element) {
        try {
            for (Modifier m : element.getModifiers()) {
                this.parent.doSwitch((EObject)m);
            }
            this.writer.append("{\n");
            for (Statement s : element.getStatements()) {
                this.parent.doSwitch((EObject)s);
            }
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseReturn(Return element) {
        try {
            this.writer.append("return");
            if (element.getReturnValue() != null) {
                this.writer.append(" ");
                this.parent.doSwitch((EObject)element.getReturnValue());
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseSwitch(Switch element) {
        try {
            this.writer.append("switch (");
            this.parent.doSwitch((EObject)element.getVariable());
            this.writer.append(") {\n");
            for (SwitchCase cas : element.getCases()) {
                this.parent.doSwitch((EObject)cas);
            }
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDefaultSwitchCase(DefaultSwitchCase element) {
        try {
            this.writer.append("default: ");
            for (Statement s : element.getStatements()) {
                this.parent.doSwitch((EObject)s);
            }
            this.writer.append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseNormalSwitchCase(NormalSwitchCase element) {
        try {
            this.writer.append("case ");
            this.parent.doSwitch((EObject)element.getCondition());
            for (Expression expr : element.getAdditionalConditions()) {
                this.writer.append(", ");
                this.parent.doSwitch((EObject)expr);
            }
            this.writer.append(": ");
            for (Statement s : element.getStatements()) {
                this.parent.doSwitch((EObject)s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDefaultSwitchRule(DefaultSwitchRule element) {
        try {
            this.writer.append("default -> ");
            for (Statement s : element.getStatements()) {
                this.parent.doSwitch((EObject)s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseNormalSwitchRule(NormalSwitchRule element) {
        try {
            this.writer.append("case ");
            this.parent.doSwitch((EObject)element.getCondition());
            for (Expression expr : element.getAdditionalConditions()) {
                this.writer.append(", ");
                this.parent.doSwitch((EObject)expr);
            }
            this.writer.append(" -> ");
            for (Statement s : element.getStatements()) {
                this.parent.doSwitch((EObject)s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseSynchronizedBlock(SynchronizedBlock element) {
        try {
            this.writer.append("synchronized (");
            this.parent.doSwitch((EObject)element.getLockProvider());
            this.writer.append(") ");
            this.parent.doSwitch((EObject)element.getBlock());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseThrow(Throw element) {
        try {
            this.writer.append("throw ");
            this.parent.doSwitch((EObject)element.getThrowable());
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseTryBlock(TryBlock element) {
        try {
            this.writer.append("try");
            if (element.getResources().size() > 0) {
                this.writer.append("(");
                this.parent.doSwitch((EObject)element.getResources().get(0));
                for (int index = 1; index < element.getResources().size(); ++index) {
                    this.writer.append("; ");
                    this.parent.doSwitch((EObject)element.getResources().get(index));
                }
                this.writer.append(")");
            }
            this.writer.append(" ");
            this.parent.doSwitch((EObject)element.getBlock());
            for (CatchBlock cat : element.getCatchBlocks()) {
                this.caseCatchBlock(cat);
            }
            if (element.getFinallyBlock() != null) {
                this.writer.append("finally ");
                this.parent.doSwitch((EObject)element.getFinallyBlock());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseYieldStatement(YieldStatement element) {
        try {
            this.writer.append("yield ");
            this.parent.doSwitch((EObject)element.getYieldExpression());
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseWhileLoop(WhileLoop element) {
        try {
            this.writer.append("while (");
            this.parent.doSwitch((EObject)element.getCondition());
            this.writer.append(")\n");
            this.parent.doSwitch((EObject)element.getStatement());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

