/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.arrays.ArraySelector;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.generics.GenericsPackage;
import tools.mdsd.jamopp.model.java.references.Argumentable;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.PrimitiveTypeReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.model.java.references.TextBlockReference;
import tools.mdsd.jamopp.model.java.references.util.ReferencesSwitch;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

public class ReferencesPrinterSwitch
extends ReferencesSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    ReferencesPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseArgumentable(Argumentable element) {
        try {
            this.writer.append("(");
            for (int index = 0; index < element.getArguments().size(); ++index) {
                this.parent.doSwitch((EObject)element.getArguments().get(index));
                if (index >= element.getArguments().size() - 1) continue;
                this.writer.append(", ");
            }
            this.writer.append(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseTextBlockReference(TextBlockReference element) {
        try {
            this.writer.append("\"\"\"\n");
            this.writer.append(element.getValue());
            this.writer.append("\n\"\"\"");
            this.caseReference((Reference)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseReflectiveClassReference(ReflectiveClassReference element) {
        try {
            this.writer.append("class");
            this.caseReference((Reference)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean casePrimitiveTypeReference(PrimitiveTypeReference element) {
        this.parent.doSwitch((EObject)element.getPrimitiveType());
        element.getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
        element.getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
        this.caseReference((Reference)element);
        return true;
    }

    public Boolean caseStringReference(StringReference element) {
        try {
            this.writer.append("\"" + element.getValue() + "\"");
            this.caseReference((Reference)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseSelfReference(SelfReference element) {
        this.parent.doSwitch((EObject)element.getSelf());
        this.caseReference((Reference)element);
        return true;
    }

    public Boolean caseIdentifierReference(IdentifierReference element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            if (element.getTarget() instanceof Package) {
                Package pack = (Package)element.getTarget();
                this.writer.append((CharSequence)pack.getNamespaces().get(pack.getNamespaces().size() - 1));
            } else {
                this.writer.append(element.getTarget().getName());
            }
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            element.getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.caseReference((Reference)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseMethodCall(MethodCall element) {
        try {
            this.parent.doSwitch(GenericsPackage.Literals.CALL_TYPE_ARGUMENTABLE, (EObject)element);
            this.writer.append(element.getTarget().getName());
            this.caseArgumentable((Argumentable)element);
            this.caseReference((Reference)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseReference(Reference element) {
        try {
            for (ArraySelector sel : element.getArraySelectors()) {
                this.parent.doSwitch((EObject)sel);
            }
            if (element.getNext() != null) {
                this.writer.append(".");
                this.parent.doSwitch((EObject)element.getNext());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

