/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.generics.GenericsPackage;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersPackage;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.Parametrizable;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.parameters.util.ParametersSwitch;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class ParametersPrinterSwitch
extends ParametersSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    ParametersPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseParametrizable(Parametrizable element) {
        try {
            this.writer.append("(");
            for (int index = 0; index < element.getParameters().size(); ++index) {
                Parameter param = (Parameter)element.getParameters().get(index);
                this.parent.doSwitch((EObject)param);
                if (index >= element.getParameters().size() - 1) continue;
                this.writer.append(", ");
            }
            this.writer.append(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseReceiverParameter(ReceiverParameter element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            this.writer.append(" ");
            if (element.getOuterTypeReference() != null) {
                this.parent.doSwitch((EObject)element.getOuterTypeReference());
                this.writer.append(".");
            }
            this.writer.append("this");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseOrdinaryParameter(OrdinaryParameter element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append(" " + element.getName());
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseVariableLengthParameter(VariableLengthParameter element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append(" ");
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append(" ..." + element.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseCatchParameter(CatchParameter element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch((EObject)element.getTypeReference());
            if (element.getTypeReferences().size() > 0) {
                for (TypeReference ref : element.getTypeReferences()) {
                    this.writer.append(" | ");
                    this.parent.doSwitch((EObject)ref);
                }
            }
            this.writer.append(" " + element.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

