/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.modifiers.Static;
import tools.mdsd.jamopp.model.java.modules.AccessProvidingModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ExportsModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ModuleReference;
import tools.mdsd.jamopp.model.java.modules.OpensModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ProvidesModuleDirective;
import tools.mdsd.jamopp.model.java.modules.RequiresModuleDirective;
import tools.mdsd.jamopp.model.java.modules.UsesModuleDirective;
import tools.mdsd.jamopp.model.java.modules.util.ModulesSwitch;
import tools.mdsd.jamopp.model.java.types.TypeReference;

class ModulesPrinterSwitch
extends ModulesSwitch<Boolean> {
    private Switch<Boolean> parent;
    private BufferedWriter writer;

    ModulesPrinterSwitch(Switch<Boolean> parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseUsesModuleDirective(UsesModuleDirective element) {
        try {
            this.writer.append("uses ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseProvidesModuleDirective(ProvidesModuleDirective element) {
        try {
            this.writer.append("provides ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.writer.append(" with ");
            for (int index = 0; index < element.getServiceProviders().size(); ++index) {
                TypeReference ref = (TypeReference)element.getServiceProviders().get(index);
                this.parent.doSwitch((EObject)ref);
                if (index >= element.getServiceProviders().size() - 1) continue;
                this.writer.append(".");
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseRequiresModuleDirective(RequiresModuleDirective element) {
        try {
            this.writer.append("requires ");
            if (element.getModifier() != null) {
                if (element.getModifier() instanceof Static) {
                    this.writer.append("static ");
                } else {
                    this.writer.append("transitive ");
                }
            }
            if (element.getRequiredModule().getTarget() != null) {
                this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)element.getRequiredModule().getTarget());
            } else {
                this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)element.getRequiredModule());
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseOpensModuleDirective(OpensModuleDirective element) {
        try {
            this.writer.append("opens ");
            this.printRemainingAccessProvidingModuleDirective((AccessProvidingModuleDirective)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseExportsModuleDirective(ExportsModuleDirective element) {
        try {
            this.writer.append("exports ");
            this.printRemainingAccessProvidingModuleDirective((AccessProvidingModuleDirective)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void printRemainingAccessProvidingModuleDirective(AccessProvidingModuleDirective element) {
        try {
            if (element.getAccessablePackage() != null) {
                this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)element.getAccessablePackage());
            } else {
                this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)element);
            }
            if (element.getModules().size() > 0) {
                this.writer.append(" to ");
                ModuleReference m = (ModuleReference)element.getModules().get(0);
                if (m.getTarget() != null) {
                    this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)m.getTarget());
                } else {
                    this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)m);
                }
                for (int index = 1; index < element.getModules().size(); ++index) {
                    this.writer.append(", ");
                    m = (ModuleReference)element.getModules().get(index);
                    if (m.getTarget() != null) {
                        this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)m.getTarget());
                        continue;
                    }
                    this.printNamespaceAwareElementWithoutTrailingDot((NamespaceAwareElement)m);
                }
            }
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printNamespaceAwareElementWithoutTrailingDot(NamespaceAwareElement nae) throws IOException {
        String n = LogicalJavaURIGenerator.packageName((NamespaceAwareElement)nae);
        n = n.substring(0, n.length() - 1);
        this.writer.append(n);
    }
}

