/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.generics.GenericsPackage;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EmptyMember;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.ExceptionThrower;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MemberContainer;
import tools.mdsd.jamopp.model.java.members.util.MembersSwitch;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersPackage;
import tools.mdsd.jamopp.model.java.modifiers.Public;
import tools.mdsd.jamopp.model.java.modifiers.Static;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersPackage;
import tools.mdsd.jamopp.model.java.references.ReferencesPackage;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class MembersPrinterSwitch
extends MembersSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    MembersPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseEnumConstant(EnumConstant element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append(element.getName() + " ");
            if (element.getArguments().size() > 0) {
                this.parent.doSwitch(ReferencesPackage.Literals.ARGUMENTABLE, (EObject)element);
            }
            if (element.getAnonymousClass() != null) {
                this.parent.doSwitch((EObject)element.getAnonymousClass());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseMemberContainer(MemberContainer element) {
        for (Member mem : element.getMembers()) {
            this.parent.doSwitch((EObject)mem);
        }
        return true;
    }

    public Boolean caseField(Field element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append(" " + element.getName());
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            if (element.getInitialValue() != null) {
                this.writer.append(" = ");
                this.parent.doSwitch((EObject)element.getInitialValue());
            }
            for (AdditionalField f : element.getAdditionalFields()) {
                this.writer.append(", ");
                this.caseAdditionalField(f);
            }
            this.writer.append(";\n\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseAdditionalField(AdditionalField element) {
        try {
            this.writer.append(element.getName());
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            if (element.getInitialValue() != null) {
                this.writer.append(" = ");
                this.parent.doSwitch((EObject)element.getInitialValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseConstructor(Constructor element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_PARAMETRIZABLE, (EObject)element);
            this.writer.append(" " + element.getName());
            this.parent.doSwitch(ParametersPackage.Literals.PARAMETRIZABLE, (EObject)element);
            this.caseExceptionThrower((ExceptionThrower)element);
            this.parent.doSwitch((EObject)element.getBlock());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseClassMethod(ClassMethod element) {
        try {
            if (element.eContainer() instanceof Enumeration) {
                Class cla;
                Type t;
                boolean isStatic = false;
                boolean isPublic = false;
                for (Modifier m : element.getModifiers()) {
                    if (m instanceof Static) {
                        isStatic = true;
                        continue;
                    }
                    if (!(m instanceof Public)) continue;
                    isPublic = true;
                }
                if (isStatic && isPublic && (element.getName().equals("valueOf") && element.getParameters().size() == 1 ? (t = ((Parameter)element.getParameters().get(0)).getTypeReference().getTarget()) instanceof Class && (cla = (Class)t).getQualifiedName().equals("java.lang.String") : element.getName().equals("values") && element.getParameters().size() == 0)) {
                    return true;
                }
            }
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_PARAMETRIZABLE, (EObject)element);
            this.writer.append(" ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append(" " + element.getName());
            this.parent.doSwitch(ParametersPackage.Literals.PARAMETRIZABLE, (EObject)element);
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.caseExceptionThrower((ExceptionThrower)element);
            this.writer.append(" ");
            this.parent.doSwitch((EObject)element.getStatement());
            this.writer.append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseInterfaceMethod(InterfaceMethod element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_PARAMETRIZABLE, (EObject)element);
            this.writer.append(" ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append(" " + element.getName());
            this.parent.doSwitch(ParametersPackage.Literals.PARAMETRIZABLE, (EObject)element);
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.caseExceptionThrower((ExceptionThrower)element);
            this.writer.append(" ");
            if (element.getDefaultValue() != null) {
                this.writer.append("default ");
                this.parent.doSwitch((EObject)element.getDefaultValue());
            }
            this.parent.doSwitch((EObject)element.getStatement());
            this.writer.append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseExceptionThrower(ExceptionThrower element) {
        try {
            if (element.getExceptions().size() > 0) {
                this.writer.append("throws ");
                this.parent.doSwitch((EObject)element.getExceptions().get(0));
                for (int index = 1; index < element.getExceptions().size(); ++index) {
                    this.writer.append(", ");
                    this.parent.doSwitch((EObject)element.getExceptions().get(index));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseEmptyMember(EmptyMember element) {
        try {
            this.writer.append(";\n\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

