/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.util.Switch;
import tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral;
import tools.mdsd.jamopp.model.java.literals.BooleanLiteral;
import tools.mdsd.jamopp.model.java.literals.CharacterLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral;
import tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.HexFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.HexLongLiteral;
import tools.mdsd.jamopp.model.java.literals.NullLiteral;
import tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.OctalLongLiteral;
import tools.mdsd.jamopp.model.java.literals.Super;
import tools.mdsd.jamopp.model.java.literals.This;
import tools.mdsd.jamopp.model.java.literals.util.LiteralsSwitch;

public class LiteralsPrinterSwitch
extends LiteralsSwitch<Boolean> {
    private Switch<Boolean> parent;
    private BufferedWriter writer;

    LiteralsPrinterSwitch(Switch<Boolean> parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseBooleanLiteral(BooleanLiteral element) {
        try {
            this.writer.append(Boolean.toString(element.isValue()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseCharacterLiteral(CharacterLiteral element) {
        try {
            this.writer.append("'" + element.getValue() + "'");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseNullLiteral(NullLiteral element) {
        try {
            this.writer.append("null");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDecimalFloatLiteral(DecimalFloatLiteral element) {
        try {
            this.writer.append(Float.toString(element.getDecimalValue()) + "F");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseHexFloatLiteral(HexFloatLiteral element) {
        try {
            this.writer.append(Float.toHexString(element.getHexValue()) + "F");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDecimalDoubleLiteral(DecimalDoubleLiteral element) {
        try {
            this.writer.append(Double.toString(element.getDecimalValue()) + "D");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseHexDoubleLiteral(HexDoubleLiteral element) {
        try {
            this.writer.append(Double.toHexString(element.getHexValue()) + "D");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDecimalIntegerLiteral(DecimalIntegerLiteral element) {
        try {
            this.writer.append(element.getDecimalValue().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseHexIntegerLiteral(HexIntegerLiteral element) {
        try {
            this.writer.append("0x" + element.getHexValue().toString(16));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseOctalIntegerLiteral(OctalIntegerLiteral element) {
        try {
            this.writer.append("0" + element.getOctalValue().toString(8));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseBinaryIntegerLiteral(BinaryIntegerLiteral element) {
        try {
            this.writer.append("0b" + element.getBinaryValue().toString(2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseDecimalLongLiteral(DecimalLongLiteral element) {
        try {
            this.writer.append(element.getDecimalValue().toString() + "L");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseHexLongLiteral(HexLongLiteral element) {
        try {
            this.writer.append("0x" + element.getHexValue().toString(16) + "L");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseOctalLongLiteral(OctalLongLiteral element) {
        try {
            this.writer.append("0" + element.getOctalValue().toString(8) + "L");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseBinaryLongLiteral(BinaryLongLiteral element) {
        try {
            this.writer.append("0b" + element.getBinaryValue().toString(2) + "L");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseThis(This element) {
        try {
            this.writer.append("this");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseSuper(Super element) {
        try {
            this.writer.append("super");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

