/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.ContainersPackage;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

public final class JaMoPPPrinter {
    private JaMoPPPrinter() {
    }

    public static void print(JavaRoot root, OutputStream output) {
        JaMoPPPrinter.print((Commentable)root, output);
    }

    public static void print(Commentable element, OutputStream output) {
        try (OutputStreamWriter outWriter = new OutputStreamWriter(output, StandardCharsets.UTF_8);
             BufferedWriter buffWriter = new BufferedWriter(outWriter);){
            JaMoPPPrinter.internalPrint(element, element instanceof JavaRoot ? ContainersPackage.Literals.JAVA_ROOT : element.eClass(), buffWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void print(JavaRoot root, Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            JaMoPPPrinter.internalPrint((Commentable)root, ContainersPackage.Literals.JAVA_ROOT, writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void internalPrint(Commentable root, EClass rootClass, BufferedWriter writer) {
        new ComposedParentPrinterSwitch(writer).doSwitch(rootClass, (EObject)root);
    }
}

