/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.imports.ClassifierImport;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportingElement;
import tools.mdsd.jamopp.model.java.imports.PackageImport;
import tools.mdsd.jamopp.model.java.imports.StaticClassifierImport;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.imports.util.ImportsSwitch;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;

class ImportsPrinterSwitch
extends ImportsSwitch<Boolean> {
    private Switch<Boolean> parent;
    private BufferedWriter writer;

    ImportsPrinterSwitch(Switch<Boolean> parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseImportingElement(ImportingElement element) {
        for (Import ele : element.getImports()) {
            this.caseImport(ele);
        }
        return true;
    }

    public Boolean caseImport(Import element) {
        try {
            this.writer.append("import ");
            this.doSwitch((EObject)element);
            this.writer.append(";\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseClassifierImport(ClassifierImport element) {
        try {
            this.writer.append(LogicalJavaURIGenerator.packageName((NamespaceAwareElement)element) + element.getClassifier().getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean casePackageImport(PackageImport element) {
        try {
            String n = LogicalJavaURIGenerator.packageName((NamespaceAwareElement)element);
            n = n.substring(0, n.length() - 1);
            this.writer.append(n);
            if (element.getClassifier() != null) {
                this.writer.append("." + element.getClassifier().getName());
            }
            this.writer.append(".*");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseStaticClassifierImport(StaticClassifierImport element) {
        try {
            this.writer.append("static " + LogicalJavaURIGenerator.packageName((NamespaceAwareElement)element) + element.getClassifier().getName() + ".*");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseStaticMemberImport(StaticMemberImport element) {
        try {
            this.writer.append("static " + LogicalJavaURIGenerator.packageName((NamespaceAwareElement)element) + element.getClassifier().getName() + "." + ((ReferenceableElement)element.getStaticMembers().get(0)).getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

