/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.generics.CallTypeArgumentable;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgumentable;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.generics.UnknownTypeArgument;
import tools.mdsd.jamopp.model.java.generics.util.GenericsSwitch;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class GenericsPrinterSwitch
extends GenericsSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    GenericsPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseTypeArgumentable(TypeArgumentable element) {
        try {
            if (element.getTypeArguments().size() > 0) {
                this.writer.append("<");
                this.parent.doSwitch((EObject)element.getTypeArguments().get(0));
                for (int index = 1; index < element.getTypeArguments().size(); ++index) {
                    this.writer.append(", ");
                    this.parent.doSwitch((EObject)element.getTypeArguments().get(index));
                }
                this.writer.append(">");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseQualifiedTypeArgument(QualifiedTypeArgument element) {
        this.parent.doSwitch((EObject)element.getTypeReference());
        return null;
    }

    public Boolean caseUnknownTypeArgument(UnknownTypeArgument element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append("?");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Boolean caseSuperTypeArgument(SuperTypeArgument element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append("? super ");
            this.parent.doSwitch((EObject)element.getSuperType());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Boolean caseExtendsTypeArgument(ExtendsTypeArgument element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append("? extends ");
            this.parent.doSwitch((EObject)element.getExtendType());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Boolean caseTypeArgument(TypeArgument element) {
        element.getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
        element.getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
        return true;
    }

    public Boolean caseCallTypeArgumentable(CallTypeArgumentable element) {
        try {
            if (element.getCallTypeArguments().size() > 0) {
                this.writer.append("<");
                this.parent.doSwitch((EObject)element.getCallTypeArguments().get(0));
                for (int index = 1; index < element.getCallTypeArguments().size(); ++index) {
                    this.writer.append(", ");
                    this.parent.doSwitch((EObject)element.getCallTypeArguments().get(index));
                }
                this.writer.append(">");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseTypeParametrizable(TypeParametrizable element) {
        try {
            if (element.getTypeParameters().size() > 0) {
                this.writer.append("<");
                this.caseTypeParameter((TypeParameter)element.getTypeParameters().get(0));
                for (int index = 1; index < element.getTypeParameters().size(); ++index) {
                    this.writer.append(", ");
                    this.caseTypeParameter((TypeParameter)element.getTypeParameters().get(index));
                }
                this.writer.append("> ");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseTypeParameter(TypeParameter element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append(element.getName());
            if (element.getExtendTypes().size() > 0) {
                this.writer.append(" extends ");
                this.parent.doSwitch((EObject)element.getExtendTypes().get(0));
                for (int index = 1; index < element.getExtendTypes().size(); ++index) {
                    this.writer.append(" & ");
                    this.parent.doSwitch((EObject)element.getExtendTypes().get(index));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

