/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.expressions.AdditiveExpression;
import tools.mdsd.jamopp.model.java.expressions.AndExpression;
import tools.mdsd.jamopp.model.java.expressions.ArrayConstructorReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.AssignmentExpression;
import tools.mdsd.jamopp.model.java.expressions.CastExpression;
import tools.mdsd.jamopp.model.java.expressions.ClassTypeConstructorReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalAndExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalOrExpression;
import tools.mdsd.jamopp.model.java.expressions.EqualityExpression;
import tools.mdsd.jamopp.model.java.expressions.ExclusiveOrExpression;
import tools.mdsd.jamopp.model.java.expressions.ExplicitlyTypedLambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.ExpressionList;
import tools.mdsd.jamopp.model.java.expressions.ImplicitlyTypedLambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.InclusiveOrExpression;
import tools.mdsd.jamopp.model.java.expressions.InstanceOfExpression;
import tools.mdsd.jamopp.model.java.expressions.LambdaExpression;
import tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpression;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.expressions.PrefixUnaryModificationExpression;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpressionReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.RelationExpression;
import tools.mdsd.jamopp.model.java.expressions.ShiftExpression;
import tools.mdsd.jamopp.model.java.expressions.SingleImplicitLambdaParameter;
import tools.mdsd.jamopp.model.java.expressions.SuffixUnaryModificationExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryExpression;
import tools.mdsd.jamopp.model.java.expressions.util.ExpressionsSwitch;
import tools.mdsd.jamopp.model.java.generics.GenericsPackage;
import tools.mdsd.jamopp.model.java.operators.UnaryOperator;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.references.ReferencesPackage;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class ExpressionsPrinterSwitch
extends ExpressionsSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    ExpressionsPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseLambdaExpression(LambdaExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getParameters());
            this.writer.append(" -> ");
            this.parent.doSwitch((EObject)element.getBody());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseSingleImplicitLambdaParameter(SingleImplicitLambdaParameter element) {
        try {
            this.writer.append(((Parameter)element.getParameters().get(0)).getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseImplicitlyTypedLambdaParameters(ImplicitlyTypedLambdaParameters element) {
        try {
            this.writer.append("(");
            for (int index = 0; index < element.getParameters().size(); ++index) {
                this.writer.append(((Parameter)element.getParameters().get(index)).getName());
                if (index >= element.getParameters().size() - 1) continue;
                this.writer.append(", ");
            }
            this.writer.append(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseExplicitlyTypedLambdaParameters(ExplicitlyTypedLambdaParameters element) {
        try {
            this.writer.append("(");
            for (int index = 0; index < element.getParameters().size(); ++index) {
                Parameter param = (Parameter)element.getParameters().get(index);
                this.parent.doSwitch((EObject)param);
                if (index >= element.getParameters().size() - 1) continue;
                this.writer.append(", ");
            }
            this.writer.append(")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseAssignmentExpression(AssignmentExpression element) {
        this.parent.doSwitch((EObject)element.getChild());
        if (element.getAssignmentOperator() != null) {
            this.parent.doSwitch((EObject)element.getAssignmentOperator());
            this.parent.doSwitch((EObject)element.getValue());
        }
        return true;
    }

    public Boolean caseConditionalExpression(ConditionalExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChild());
            if (element.getExpressionIf() != null) {
                this.writer.append(" ? ");
                this.parent.doSwitch((EObject)element.getExpressionIf());
                this.writer.append(" : ");
                this.parent.doSwitch((EObject)element.getGeneralExpressionElse());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseConditionalOrExpression(ConditionalOrExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChildren().get(0));
            for (int index = 1; index < element.getChildren().size(); ++index) {
                this.writer.append(" || ");
                this.parent.doSwitch((EObject)element.getChildren().get(index));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseConditionalAndExpression(ConditionalAndExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChildren().get(0));
            for (int index = 1; index < element.getChildren().size(); ++index) {
                this.writer.append(" && ");
                this.parent.doSwitch((EObject)element.getChildren().get(index));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseInclusiveOrExpression(InclusiveOrExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChildren().get(0));
            for (int index = 1; index < element.getChildren().size(); ++index) {
                this.writer.append(" | ");
                this.parent.doSwitch((EObject)element.getChildren().get(index));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseExclusiveOrExpression(ExclusiveOrExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChildren().get(0));
            for (int index = 1; index < element.getChildren().size(); ++index) {
                this.writer.append(" ^ ");
                this.parent.doSwitch((EObject)element.getChildren().get(index));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseAndExpression(AndExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChildren().get(0));
            for (int index = 1; index < element.getChildren().size(); ++index) {
                this.writer.append(" & ");
                this.parent.doSwitch((EObject)element.getChildren().get(index));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseEqualityExpression(EqualityExpression element) {
        this.parent.doSwitch((EObject)element.getChildren().get(0));
        for (int index = 1; index < element.getChildren().size(); ++index) {
            this.parent.doSwitch((EObject)element.getEqualityOperators().get(index - 1));
            this.parent.doSwitch((EObject)element.getChildren().get(index));
        }
        return true;
    }

    public Boolean caseInstanceOfExpression(InstanceOfExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChild());
            this.writer.append(" instanceof ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseRelationExpression(RelationExpression element) {
        this.parent.doSwitch((EObject)element.getChildren().get(0));
        for (int index = 1; index < element.getChildren().size(); ++index) {
            this.parent.doSwitch((EObject)element.getRelationOperators().get(index - 1));
            this.parent.doSwitch((EObject)element.getChildren().get(index));
        }
        return true;
    }

    public Boolean caseShiftExpression(ShiftExpression element) {
        this.parent.doSwitch((EObject)element.getChildren().get(0));
        for (int index = 1; index < element.getChildren().size(); ++index) {
            this.parent.doSwitch((EObject)element.getShiftOperators().get(index - 1));
            this.parent.doSwitch((EObject)element.getChildren().get(index));
        }
        return true;
    }

    public Boolean caseAdditiveExpression(AdditiveExpression element) {
        this.parent.doSwitch((EObject)element.getChildren().get(0));
        for (int index = 1; index < element.getChildren().size(); ++index) {
            this.parent.doSwitch((EObject)element.getAdditiveOperators().get(index - 1));
            this.parent.doSwitch((EObject)element.getChildren().get(index));
        }
        return true;
    }

    public Boolean caseMultiplicativeExpression(MultiplicativeExpression element) {
        this.parent.doSwitch((EObject)element.getChildren().get(0));
        for (int index = 1; index < element.getChildren().size(); ++index) {
            this.parent.doSwitch((EObject)element.getMultiplicativeOperators().get(index - 1));
            this.parent.doSwitch((EObject)element.getChildren().get(index));
        }
        return true;
    }

    public Boolean caseUnaryExpression(UnaryExpression element) {
        for (UnaryOperator op : element.getOperators()) {
            this.parent.doSwitch((EObject)op);
        }
        this.parent.doSwitch((EObject)element.getChild());
        return true;
    }

    public Boolean casePrefixUnaryModificationExpression(PrefixUnaryModificationExpression element) {
        if (element.getOperator() != null) {
            this.parent.doSwitch((EObject)element.getOperator());
        }
        this.parent.doSwitch((EObject)element.getChild());
        return true;
    }

    public Boolean caseSuffixUnaryModificationExpression(SuffixUnaryModificationExpression element) {
        this.parent.doSwitch((EObject)element.getChild());
        if (element.getOperator() != null) {
            this.parent.doSwitch((EObject)element.getOperator());
        }
        return true;
    }

    public Boolean caseCastExpression(CastExpression element) {
        try {
            this.writer.append("(");
            this.parent.doSwitch((EObject)element.getTypeReference());
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            for (TypeReference ref : element.getAdditionalBounds()) {
                this.writer.append(" & ");
                this.parent.doSwitch((EObject)ref);
            }
            this.writer.append(") ");
            this.parent.doSwitch((EObject)element.getGeneralChild());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean casePrimaryExpressionReferenceExpression(PrimaryExpressionReferenceExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getChild());
            if (element.getMethodReference() != null) {
                this.writer.append("::");
                this.parent.doSwitch(GenericsPackage.Literals.CALL_TYPE_ARGUMENTABLE, (EObject)element);
                this.parent.doSwitch((EObject)element.getMethodReference());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseClassTypeConstructorReferenceExpression(ClassTypeConstructorReferenceExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.writer.append("::");
            this.parent.doSwitch(GenericsPackage.Literals.CALL_TYPE_ARGUMENTABLE, (EObject)element);
            this.writer.append("new");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseArrayConstructorReferenceExpression(ArrayConstructorReferenceExpression element) {
        try {
            this.parent.doSwitch((EObject)element.getTypeReference());
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append("::new");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseNestedExpression(NestedExpression element) {
        try {
            this.writer.append("(");
            this.parent.doSwitch((EObject)element.getExpression());
            this.writer.append(")");
            this.parent.doSwitch(ReferencesPackage.Literals.REFERENCE, (EObject)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseExpressionList(ExpressionList element) {
        try {
            for (int index = 0; index < element.getExpressions().size(); ++index) {
                this.parent.doSwitch((EObject)element.getExpressions().get(index));
                if (index >= element.getExpressions().size() - 1) continue;
                this.writer.append(", ");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

