/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.util.ContainersSwitch;
import tools.mdsd.jamopp.model.java.imports.ImportsPackage;
import tools.mdsd.jamopp.model.java.modules.ModuleDirective;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class ContainersPrinterSwitch
extends ContainersSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    ContainersPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseJavaRoot(JavaRoot root) {
        try {
            if (root instanceof Module) {
                this.parent.doSwitch(ImportsPackage.Literals.IMPORTING_ELEMENT, (EObject)root);
                this.caseModule((Module)root);
            } else {
                if (root.getNamespaces().size() > 0) {
                    this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)root);
                    String p = root.getNamespacesAsString();
                    p = p.substring(0, p.length() - 1);
                    this.writer.append("package " + p + ";\n\n");
                }
                this.parent.doSwitch(ImportsPackage.Literals.IMPORTING_ELEMENT, (EObject)root);
                if (root instanceof CompilationUnit) {
                    this.caseCompilationUnit((CompilationUnit)root);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseModule(Module element) {
        try {
            this.writer.append("module ");
            if (element.getOpen() != null) {
                this.writer.append("open ");
            }
            String n = LogicalJavaURIGenerator.packageName((NamespaceAwareElement)element);
            n = n.substring(0, n.length() - 1);
            this.writer.append(n);
            this.writer.append(" {\n");
            for (ModuleDirective dir : element.getTarget()) {
                this.parent.doSwitch((EObject)dir);
            }
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseCompilationUnit(CompilationUnit element) {
        for (ConcreteClassifier classifier : element.getClassifiers()) {
            this.parent.doSwitch((EObject)classifier);
        }
        return true;
    }
}

