/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Implementor;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.classifiers.util.ClassifiersSwitch;
import tools.mdsd.jamopp.model.java.generics.GenericsPackage;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.MembersPackage;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersPackage;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class ClassifiersPrinterSwitch
extends ClassifiersSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    ClassifiersPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseClass(Class element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.writer.append("class " + element.getName());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_PARAMETRIZABLE, (EObject)element);
            this.writer.append(" ");
            if (element.getExtends() != null) {
                this.writer.append("extends ");
                this.parent.doSwitch((EObject)element.getExtends());
                this.writer.append(" ");
            }
            this.caseImplementor((Implementor)element);
            this.writer.append("{\n");
            this.parent.doSwitch(MembersPackage.Literals.MEMBER_CONTAINER, (EObject)element);
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseAnonymousClass(AnonymousClass element) {
        try {
            this.writer.append("{\n");
            this.parent.doSwitch(MembersPackage.Literals.MEMBER_CONTAINER, (EObject)element);
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseImplementor(Implementor element) {
        try {
            if (element.getImplements().size() > 0) {
                this.writer.append("implements ");
                this.parent.doSwitch((EObject)element.getImplements().get(0));
                for (int index = 1; index < element.getImplements().size(); ++index) {
                    this.writer.append(", ");
                    this.parent.doSwitch((EObject)element.getImplements().get(index));
                }
                this.writer.append(" ");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseEnumeration(Enumeration element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.writer.append("enum " + element.getName() + " ");
            this.caseImplementor((Implementor)element);
            this.writer.append("{\n");
            for (EnumConstant enc : element.getConstants()) {
                this.parent.doSwitch((EObject)enc);
                this.writer.append(",\n");
            }
            if (element.getMembers().size() > 0) {
                this.writer.append(";\n\n");
                this.parent.doSwitch(MembersPackage.Literals.MEMBER_CONTAINER, (EObject)element);
            }
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseInterface(Interface element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.writer.append("interface " + element.getName());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_PARAMETRIZABLE, (EObject)element);
            this.writer.append(" ");
            if (element.getExtends().size() > 0) {
                this.writer.append("extends ");
                this.parent.doSwitch((EObject)element.getExtends().get(0));
                for (int index = 1; index < element.getExtends().size(); ++index) {
                    this.writer.append(", ");
                    this.parent.doSwitch((EObject)element.getExtends().get(index));
                }
                this.writer.append(" ");
            }
            this.writer.append("{\n");
            this.parent.doSwitch(MembersPackage.Literals.MEMBER_CONTAINER, (EObject)element);
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseAnnotation(Annotation element) {
        try {
            this.parent.doSwitch(ModifiersPackage.Literals.ANNOTABLE_AND_MODIFIABLE, (EObject)element);
            this.writer.append("@interface " + element.getName() + " {\n");
            this.parent.doSwitch(MembersPackage.Literals.MEMBER_CONTAINER, (EObject)element);
            this.writer.append("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

