/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsPackage;
import tools.mdsd.jamopp.model.java.arrays.ArrayDimension;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializationValue;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializer;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationBySize;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationByValuesTyped;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationByValuesUntyped;
import tools.mdsd.jamopp.model.java.arrays.ArraySelector;
import tools.mdsd.jamopp.model.java.arrays.util.ArraysSwitch;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.generics.GenericsPackage;
import tools.mdsd.jamopp.model.java.references.ReferencesPackage;
import tools.mdsd.jamopp.printer.ComposedParentPrinterSwitch;

class ArraysPrinterSwitch
extends ArraysSwitch<Boolean> {
    private ComposedParentPrinterSwitch parent;
    private BufferedWriter writer;

    ArraysPrinterSwitch(ComposedParentPrinterSwitch parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseArrayDimension(ArrayDimension element) {
        try {
            if (element.getAnnotations().size() > 0) {
                this.writer.append(" ");
                this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            }
            this.writer.append("[] ");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseArraySelector(ArraySelector element) {
        try {
            this.parent.doSwitch(AnnotationsPackage.Literals.ANNOTABLE, (EObject)element);
            this.writer.append("[");
            this.parent.doSwitch((EObject)element.getPosition());
            this.writer.append("]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseArrayInstantiationBySize(ArrayInstantiationBySize element) {
        try {
            this.writer.append("new ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            this.writer.append(" ");
            for (Expression expr : element.getSizes()) {
                this.writer.append("[");
                this.parent.doSwitch((EObject)expr);
                this.writer.append("] ");
            }
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.parent.doSwitch(ReferencesPackage.Literals.REFERENCE, (EObject)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseArrayInstantiationByValuesUntyped(ArrayInstantiationByValuesUntyped element) {
        this.caseArrayInitializer(element.getArrayInitializer());
        this.parent.doSwitch(ReferencesPackage.Literals.REFERENCE, (EObject)element);
        return true;
    }

    public Boolean caseArrayInstantiationByValuesTyped(ArrayInstantiationByValuesTyped element) {
        try {
            this.writer.append("new ");
            this.parent.doSwitch((EObject)element.getTypeReference());
            this.parent.doSwitch(GenericsPackage.Literals.TYPE_ARGUMENTABLE, (EObject)element);
            element.getTypeReference().getArrayDimensionsBefore().forEach(dim -> this.parent.doSwitch((EObject)dim));
            element.getTypeReference().getArrayDimensionsAfter().forEach(dim -> this.parent.doSwitch((EObject)dim));
            this.writer.append(" ");
            this.caseArrayInitializer(element.getArrayInitializer());
            this.parent.doSwitch(ReferencesPackage.Literals.REFERENCE, (EObject)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Boolean caseArrayInitializer(ArrayInitializer element) {
        try {
            this.writer.append("{");
            for (int index = 0; index < element.getInitialValues().size(); ++index) {
                ArrayInitializationValue val = (ArrayInitializationValue)element.getInitialValues().get(index);
                this.parent.doSwitch((EObject)val);
                if (index >= element.getInitialValues().size() - 1) continue;
                this.writer.append(", ");
            }
            this.writer.append("}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

