/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.printer;

import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import tools.mdsd.jamopp.model.java.LogicalJavaURIGenerator;
import tools.mdsd.jamopp.model.java.annotations.Annotable;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameterList;
import tools.mdsd.jamopp.model.java.annotations.SingleAnnotationParameter;
import tools.mdsd.jamopp.model.java.annotations.util.AnnotationsSwitch;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;

class AnnotationsPrinterSwitch
extends AnnotationsSwitch<Boolean> {
    private Switch<Boolean> parent;
    private BufferedWriter writer;

    AnnotationsPrinterSwitch(Switch<Boolean> parent, BufferedWriter writer) {
        this.parent = parent;
        this.writer = writer;
    }

    public Boolean caseAnnotable(Annotable element) {
        for (AnnotationInstance inst : element.getAnnotations()) {
            this.caseAnnotationInstance(inst);
        }
        return true;
    }

    public Boolean caseAnnotationInstance(AnnotationInstance element) {
        try {
            this.writer.append("@");
            if (element.getNamespaces().size() > 0) {
                this.writer.append(LogicalJavaURIGenerator.packageName((NamespaceAwareElement)element));
            }
            this.writer.append(element.getAnnotation().getName());
            if (element.getParameter() != null) {
                this.writer.append("(");
                if (element.getParameter() instanceof SingleAnnotationParameter) {
                    this.parent.doSwitch((EObject)((SingleAnnotationParameter)element.getParameter()).getValue());
                } else {
                    AnnotationParameterList list = (AnnotationParameterList)element.getParameter();
                    for (int index = 0; index < list.getSettings().size(); ++index) {
                        AnnotationAttributeSetting setting = (AnnotationAttributeSetting)list.getSettings().get(index);
                        this.writer.append(setting.getAttribute().getName() + " = ");
                        this.parent.doSwitch((EObject)setting.getValue());
                        if (index >= list.getSettings().size() - 1) continue;
                        this.writer.append(", ");
                    }
                }
                this.writer.append(")");
            }
            this.writer.append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

