/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.SingleAnnotationParameter;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.parser.jdt.AnnotationInstanceOrModifierConverterUtility;
import tools.mdsd.jamopp.parser.jdt.ExpressionConverterUtility;
import tools.mdsd.jamopp.parser.jdt.JDTResolverUtility;
import tools.mdsd.jamopp.parser.jdt.StatementConverterUtility;

public class TypeInstructionSeparationUtility {
    private static HashMap<Block, Method> methods = new HashMap();
    private static HashMap<Block, Constructor> constructors = new HashMap();
    private static HashMap<Expression, Field> fields = new HashMap();
    private static HashMap<Expression, AdditionalField> addFields = new HashMap();
    private static HashMap<Block, tools.mdsd.jamopp.model.java.statements.Block> initializers = new HashMap();
    private static HashMap<Expression, InterfaceMethod> annotationMethods = new HashMap();
    private static HashMap<Expression, SingleAnnotationParameter> singleAnnotations = new HashMap();
    private static HashMap<Expression, AnnotationAttributeSetting> annotationSetting = new HashMap();
    private static HashSet<EObject> visitedObjects = new HashSet();

    static void addMethod(Block block, Method method) {
        methods.put(block, method);
    }

    static void addConstructor(Block block, Constructor constructor) {
        constructors.put(block, constructor);
    }

    static void addField(Expression initializer, Field field) {
        fields.put(initializer, field);
    }

    static void addAdditionalField(Expression initializer, AdditionalField field) {
        addFields.put(initializer, field);
    }

    static void addInitializer(Block block, tools.mdsd.jamopp.model.java.statements.Block correspondingBlock) {
        initializers.put(block, correspondingBlock);
    }

    static void addAnnotationMethod(Expression value, InterfaceMethod method) {
        annotationMethods.put(value, method);
    }

    static void addSingleAnnotationParameter(Expression value, SingleAnnotationParameter param) {
        singleAnnotations.put(value, param);
    }

    static void addAnnotationAttributeSetting(Expression value, AnnotationAttributeSetting setting) {
        annotationSetting.put(value, setting);
    }

    static void convertAll() {
        int oldSize;
        int newSize = methods.size() + constructors.size() + fields.size() + addFields.size() + initializers.size() + annotationMethods.size() + singleAnnotations.size() + annotationSetting.size();
        do {
            oldSize = newSize;
            HashMap clonedMethods = (HashMap)methods.clone();
            Iterator iter = clonedMethods.keySet().iterator();
            while (iter.hasNext()) {
                if (!visitedObjects.contains(clonedMethods.get(iter.next()))) continue;
                iter.remove();
            }
            clonedMethods.forEach((b, m) -> {
                visitedObjects.add((EObject)m);
                m.setStatement((tools.mdsd.jamopp.model.java.statements.Statement)StatementConverterUtility.convertToBlock(b));
            });
            HashMap clonedConstructors = (HashMap)constructors.clone();
            iter = clonedConstructors.keySet().iterator();
            while (iter.hasNext()) {
                if (!visitedObjects.contains(clonedConstructors.get(iter.next()))) continue;
                iter.remove();
            }
            clonedConstructors.forEach((b, c) -> {
                visitedObjects.add((EObject)c);
                c.setBlock(StatementConverterUtility.convertToBlock(b));
            });
            HashMap clonedFields = (HashMap)fields.clone();
            Iterator exprIter = clonedFields.keySet().iterator();
            while (exprIter.hasNext()) {
                if (!visitedObjects.contains(clonedFields.get(exprIter.next()))) continue;
                exprIter.remove();
            }
            clonedFields.forEach((expr, f) -> {
                visitedObjects.add((EObject)f);
                f.setInitialValue(ExpressionConverterUtility.convertToExpression(expr));
            });
            HashMap clonedAddFields = (HashMap)addFields.clone();
            exprIter = clonedAddFields.keySet().iterator();
            while (exprIter.hasNext()) {
                if (!visitedObjects.contains(clonedAddFields.get(exprIter.next()))) continue;
                exprIter.remove();
            }
            clonedAddFields.forEach((expr, f) -> {
                visitedObjects.add((EObject)f);
                f.setInitialValue(ExpressionConverterUtility.convertToExpression(expr));
            });
            HashMap clonedInitializers = (HashMap)initializers.clone();
            iter = clonedInitializers.keySet().iterator();
            while (iter.hasNext()) {
                if (!visitedObjects.contains(clonedInitializers.get(iter.next()))) continue;
                iter.remove();
            }
            clonedInitializers.forEach((b1, b2) -> {
                visitedObjects.add((EObject)b2);
                JDTResolverUtility.prepareNextUid();
                b1.statements().forEach(obj -> b2.getStatements().add((Object)StatementConverterUtility.convertToStatement((Statement)obj)));
            });
            HashMap clonedAnnotationMethods = (HashMap)annotationMethods.clone();
            exprIter = clonedAnnotationMethods.keySet().iterator();
            while (exprIter.hasNext()) {
                if (!visitedObjects.contains(clonedAnnotationMethods.get(exprIter.next()))) continue;
                exprIter.remove();
            }
            clonedAnnotationMethods.forEach((expr, m) -> {
                visitedObjects.add((EObject)m);
                m.setDefaultValue(AnnotationInstanceOrModifierConverterUtility.convertToAnnotationValue(expr));
            });
            HashMap clonedSingleAnnotations = (HashMap)singleAnnotations.clone();
            exprIter = clonedSingleAnnotations.keySet().iterator();
            while (exprIter.hasNext()) {
                if (!visitedObjects.contains(clonedSingleAnnotations.get(exprIter.next()))) continue;
                exprIter.remove();
            }
            clonedSingleAnnotations.forEach((expr, sap) -> {
                visitedObjects.add((EObject)sap);
                sap.setValue(AnnotationInstanceOrModifierConverterUtility.convertToAnnotationValue(expr));
            });
            HashMap clonedAnnotationSetting = (HashMap)annotationSetting.clone();
            exprIter = clonedAnnotationSetting.keySet().iterator();
            while (exprIter.hasNext()) {
                if (!visitedObjects.contains(clonedAnnotationSetting.get(exprIter.next()))) continue;
                exprIter.remove();
            }
            clonedAnnotationSetting.forEach((expr, aas) -> {
                visitedObjects.add((EObject)aas);
                aas.setValue(AnnotationInstanceOrModifierConverterUtility.convertToAnnotationValue(expr));
            });
        } while ((newSize = methods.size() + constructors.size() + fields.size() + addFields.size() + initializers.size() + annotationMethods.size() + singleAnnotations.size() + annotationSetting.size()) != oldSize);
        methods.clear();
        constructors.clear();
        fields.clear();
        addFields.clear();
        initializers.clear();
        annotationMethods.clear();
        singleAnnotations.clear();
        annotationSetting.clear();
        visitedObjects.clear();
    }
}

