/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import java.math.BigInteger;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.NumberLiteral;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.parser.jdt.LayoutInformationConverter;

class NumberLiteralConverterUtility {
    private static final String HEX_PREFIX = "0x";
    private static final String BIN_PREFIX = "0b";
    private static final String OCT_PREFIX = "0";
    private static final String LONG_SUFFIX = "l";
    private static final String FLOAT_SUFFIX = "f";
    private static final String DOUBLE_SUFFIX = "d";
    private static final String DECIMAL_EXPONENT = "e";
    private static final String HEX_EXPONENT = "p";
    private static final int BIN_BASE = 2;
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int OCT_BASE = 8;
    private static final String UNDER_SCORE = "_";

    NumberLiteralConverterUtility() {
    }

    static Literal convertToLiteral(NumberLiteral literal) {
        BinaryLongLiteral result = null;
        String string = literal.getToken();
        if (string.contains("\\u")) {
            StringBuilder actualLiteral = new StringBuilder();
            for (int index = 0; index < string.length(); ++index) {
                char currentChar = string.charAt(index);
                if (currentChar == '\\') {
                    int codePoint = Integer.parseInt(string.substring(index + 2, index + 6), 16);
                    actualLiteral.append(Character.toString(codePoint));
                    index += 5;
                    continue;
                }
                actualLiteral.append(currentChar);
            }
            string = actualLiteral.toString();
        }
        string = string.replaceAll(UNDER_SCORE, "");
        if ((string = string.toLowerCase()).startsWith(BIN_PREFIX) && string.endsWith(LONG_SUFFIX)) {
            lit = LiteralsFactory.eINSTANCE.createBinaryLongLiteral();
            lit.setBinaryValue(new BigInteger(string.substring(BIN_PREFIX.length(), string.length() - LONG_SUFFIX.length()), 2));
            result = lit;
        } else if (string.startsWith(BIN_PREFIX)) {
            lit = LiteralsFactory.eINSTANCE.createBinaryIntegerLiteral();
            lit.setBinaryValue(new BigInteger(string.substring(BIN_PREFIX.length()), 2));
            result = lit;
        } else if (string.contains(HEX_EXPONENT) && string.endsWith(FLOAT_SUFFIX)) {
            lit = LiteralsFactory.eINSTANCE.createHexFloatLiteral();
            lit.setHexValue(Float.parseFloat(string.substring(0, string.length() - FLOAT_SUFFIX.length())));
            result = lit;
        } else if (string.contains(HEX_EXPONENT)) {
            if (string.endsWith(DOUBLE_SUFFIX)) {
                string = string.substring(0, string.length() - DOUBLE_SUFFIX.length());
            }
            lit = LiteralsFactory.eINSTANCE.createHexDoubleLiteral();
            lit.setHexValue(Double.parseDouble(string));
            result = lit;
        } else if (string.startsWith(HEX_PREFIX) && string.endsWith(LONG_SUFFIX)) {
            lit = LiteralsFactory.eINSTANCE.createHexLongLiteral();
            lit.setHexValue(new BigInteger(string.substring(HEX_PREFIX.length(), string.length() - LONG_SUFFIX.length()), 16));
            result = lit;
        } else if (string.startsWith(HEX_PREFIX)) {
            lit = LiteralsFactory.eINSTANCE.createHexIntegerLiteral();
            lit.setHexValue(new BigInteger(string.substring(HEX_PREFIX.length()), 16));
            result = lit;
        } else if (string.endsWith(FLOAT_SUFFIX)) {
            lit = LiteralsFactory.eINSTANCE.createDecimalFloatLiteral();
            lit.setDecimalValue(Float.parseFloat(string.substring(0, string.length() - FLOAT_SUFFIX.length())));
            result = lit;
        } else if (string.contains(".") || string.contains(DECIMAL_EXPONENT) || string.endsWith(DOUBLE_SUFFIX)) {
            if (string.endsWith(DOUBLE_SUFFIX)) {
                string = string.substring(0, string.length() - DOUBLE_SUFFIX.length());
            }
            lit = LiteralsFactory.eINSTANCE.createDecimalDoubleLiteral();
            lit.setDecimalValue(Double.parseDouble(string));
            result = lit;
        } else if (string.equals("0l") || !string.startsWith(OCT_PREFIX) && string.endsWith(LONG_SUFFIX)) {
            lit = LiteralsFactory.eINSTANCE.createDecimalLongLiteral();
            lit.setDecimalValue(new BigInteger(string.substring(0, string.length() - LONG_SUFFIX.length()), 10));
            result = lit;
        } else if (string.equals(OCT_PREFIX) || !string.startsWith(OCT_PREFIX)) {
            lit = LiteralsFactory.eINSTANCE.createDecimalIntegerLiteral();
            lit.setDecimalValue(new BigInteger(string, 10));
            result = lit;
        } else if (string.endsWith(LONG_SUFFIX)) {
            lit = LiteralsFactory.eINSTANCE.createOctalLongLiteral();
            lit.setOctalValue(new BigInteger(string.substring(OCT_PREFIX.length(), string.length() - LONG_SUFFIX.length()), 8));
            result = lit;
        } else {
            lit = LiteralsFactory.eINSTANCE.createOctalIntegerLiteral();
            lit.setOctalValue(new BigInteger(string.substring(OCT_PREFIX.length()), 8));
            result = lit;
        }
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)literal);
        return result;
    }
}

