/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.ModulePackageAccess;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.UsesDirective;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modifiers.ModuleRequiresModifier;
import tools.mdsd.jamopp.model.java.modules.AccessProvidingModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ModuleReference;
import tools.mdsd.jamopp.model.java.modules.ModulesFactory;
import tools.mdsd.jamopp.model.java.modules.ProvidesModuleDirective;
import tools.mdsd.jamopp.model.java.modules.RequiresModuleDirective;
import tools.mdsd.jamopp.model.java.modules.UsesModuleDirective;
import tools.mdsd.jamopp.parser.jdt.AnnotationInstanceOrModifierConverterUtility;
import tools.mdsd.jamopp.parser.jdt.BaseConverterUtility;
import tools.mdsd.jamopp.parser.jdt.JDTResolverUtility;
import tools.mdsd.jamopp.parser.jdt.LayoutInformationConverter;
import tools.mdsd.jamopp.parser.jdt.PackageJDTASTVisitorAndConverter;

class ModuleJDTASTVisitorAndConverter
extends PackageJDTASTVisitorAndConverter {
    ModuleJDTASTVisitorAndConverter() {
    }

    @Override
    public boolean visit(CompilationUnit node) {
        if (node.getModule() != null) {
            Module module = this.convertToModule(node.getModule());
            this.setConvertedElement((JavaRoot)module);
        }
        super.visit(node);
        return false;
    }

    private Module convertToModule(ModuleDeclaration node) {
        Module module = JDTResolverUtility.getModule(node.resolveBinding());
        if (node.isOpen()) {
            module.setOpen(ModifiersFactory.eINSTANCE.createOpen());
        }
        LayoutInformationConverter.convertJavaRootLayoutInformation((JavaRoot)module, (ASTNode)node, this.getSource());
        BaseConverterUtility.convertToNamespacesAndSet(node.getName(), (NamespaceAwareElement)module);
        module.setName("");
        node.annotations().forEach(obj -> module.getAnnotations().add((Object)AnnotationInstanceOrModifierConverterUtility.convertToAnnotationInstance((Annotation)obj)));
        node.moduleStatements().forEach(obj -> module.getTarget().add((Object)this.convertToDirective((ModuleDirective)obj)));
        return module;
    }

    private tools.mdsd.jamopp.model.java.modules.ModuleDirective convertToDirective(ModuleDirective directive) {
        if (directive.getNodeType() == 94) {
            RequiresDirective reqDir = (RequiresDirective)directive;
            RequiresModuleDirective result = ModulesFactory.eINSTANCE.createRequiresModuleDirective();
            reqDir.modifiers().forEach(obj -> {
                ModuleModifier modifier = (ModuleModifier)obj;
                if (modifier.isStatic()) {
                    result.setModifier((ModuleRequiresModifier)ModifiersFactory.eINSTANCE.createStatic());
                } else if (modifier.isTransitive()) {
                    result.setModifier((ModuleRequiresModifier)ModifiersFactory.eINSTANCE.createTransitive());
                }
            });
            result.setRequiredModule(this.convertToModuleReference(reqDir.getName()));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)directive);
            return result;
        }
        if (directive.getNodeType() == 95 || directive.getNodeType() == 96) {
            ModulePackageAccess accessDir = (ModulePackageAccess)directive;
            Object convertedDir = directive.getNodeType() == 96 ? ModulesFactory.eINSTANCE.createOpensModuleDirective() : ModulesFactory.eINSTANCE.createExportsModuleDirective();
            IPackageBinding binding = (IPackageBinding)accessDir.getName().resolveBinding();
            convertedDir.setAccessablePackage(JDTResolverUtility.getPackage(binding));
            accessDir.modules().forEach(arg_0 -> this.lambda$convertToDirective$3((AccessProvidingModuleDirective)convertedDir, arg_0));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)convertedDir, (ASTNode)directive);
            return convertedDir;
        }
        if (directive.getNodeType() == 98) {
            ProvidesDirective provDir = (ProvidesDirective)directive;
            ProvidesModuleDirective result = ModulesFactory.eINSTANCE.createProvidesModuleDirective();
            result.setTypeReference(BaseConverterUtility.convertToClassifierOrNamespaceClassifierReference(provDir.getName()));
            provDir.implementations().forEach(obj -> result.getServiceProviders().add((Object)BaseConverterUtility.convertToClassifierOrNamespaceClassifierReference((Name)obj)));
            LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)directive);
            return result;
        }
        UsesDirective usDir = (UsesDirective)directive;
        UsesModuleDirective result = ModulesFactory.eINSTANCE.createUsesModuleDirective();
        result.setTypeReference(BaseConverterUtility.convertToClassifierOrNamespaceClassifierReference(usDir.getName()));
        LayoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)directive);
        return result;
    }

    private ModuleReference convertToModuleReference(Name name) {
        ModuleReference ref = ModulesFactory.eINSTANCE.createModuleReference();
        Module modProxy = JDTResolverUtility.getModule((IModuleBinding)name.resolveBinding());
        modProxy.setName("");
        ref.setTarget(modProxy);
        BaseConverterUtility.convertToNamespacesAndSet(name, (NamespaceAwareElement)modProxy);
        return ref;
    }

    private /* synthetic */ void lambda$convertToDirective$3(AccessProvidingModuleDirective convertedDir, Object obj) {
        convertedDir.getModules().add((Object)this.convertToModuleReference((Name)obj));
    }
}

